# -*- coding: utf-8 -*-
from setuphelpers import *
import requests


def install():
    versionpaquet = control.get_software_version()
    install_exe_if_needed(
        "PyScripter-%s-x86-Setup.exe" % versionpaquet,
        "/VERYSILENT /NORESTART",
        key="PyScripter_is1",
        min_version=versionpaquet,
        killbefore=["PyScripter"],
    )

    for prof in local_users_profiles():
        if not "ServiceProfiles" in prof:
            if isdir(makepath(prof, "AppData", "Roaming")):
                fixconfigpyscripter(makepath(prof, "AppData", "Roaming"))


def session_setup():
    fixconfigpyscripter(application_data())
    registry_setstring(
        HKEY_CURRENT_USER,
        r"Software\Microsoft\Windows NT\CurrentVersion\AppCompatFlags\Layers",
        makepath(install_location("PyScripter_is1"), "PyScripter.exe"),
        "RUNASADMIN",
    )


def fixconfigpyscripter(prof):
    profilpy = makepath(prof, "PyScripter")
    if not isdir(profilpy):
        mkdirs(profilpy)

    if not isfile(makepath(profilpy, "PyScripter.local.ini")):
        with open(makepath(profilpy, "PyScripter.local.ini"), "w") as f:
            f.write(default_pyscripter_local_ini)
        inifile_writestring(makepath(profilpy, "PyScripter.local.ini"), "PythonVersions-x86", "InstallPath", install_location("WAPT_is1"))
        inifile_writestring(makepath(profilpy, "PyScripter.local.ini"), r"PythonVersions-x86\Custom Versions", "Path0", install_location("WAPT_is1"))
        inifile_writestring(makepath(profilpy, "PyScripter.local.ini"), r"PythonVersions-x86\Custom Versions", "Count", "0")
    inifilename = makepath(profilpy, "PyScripter.ini")
    if not isfile(inifilename):
        inifile_writestring(inifilename, r"Other Settings", "Style Name", "Windows10")
        inifile_writestring(inifilename, r"IDE Options", "AutoCompleteBrackets", "FALSE")
        inifile_writestring(inifilename, r"IDE Options", "NewFileEncoding", "sf_UTF8_NoBOM")
        inifile_writestring(inifilename, r"IDE Options", "PythonEngineType", "peRemote")
        inifile_writestring(inifilename, r"IDE Options", "AlwaysUseSockets", "TRUE")
        # Disabling update check
        inifile_writestring(inifilename, r"IDE Options", "AutoCheckForUpdates", "FALSE")
        inifile_writestring(inifilename, r"IDE Options", "DaysBetweenChecks", "0")
        inifile_writestring(inifilename, r"IDE Options", "RestoreOpenFiles", "FALSE")
    else:
        import configparser
        import io

        inifile = configparser.RawConfigParser()
        inifile.optionxform = lambda option: option
        inifile.read(inifilename, encoding="utf-8-sig")
        if not inifile.has_section(r"IDE Options"):
            inifile.add_section(r"IDE Options")
        inifile.set(r"IDE Options", "AutoCheckForUpdates", "FALSE")
        inifile.set(r"IDE Options", "DaysBetweenChecks", "0")
        inifile.write(io.open(inifilename, "w", encoding="utf-8-sig"))


def update_package():
    print("Download/Update package content from upstream binary sources")

    # Initializing variables
    app_name = control.name
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()

    url = requests.head("https://sourceforge.net/projects/pyscripter/files/latest/download?source=files", proxies=proxies).headers["Location"]
    dstexe = requests.head(url, proxies=proxies).headers["Location"].replace("-x64.zip", "-x86-Setup.exe")
    filename = dstexe.rsplit("/", 1)[1]
    version = filename.split("-")[1].replace("v", "")
    print("Latest Version : " + version)

    exes = glob.glob("*.exe")
    for fn in exes:
        if fn != filename:
            remove_file(fn)

    if not isfile(filename):
        print("Downloading %s from %s" % (filename, dstexe))
        wget(dstexe, filename, proxies=proxies)

    # Changing version of the package
    control.version = "%s-%s" % (version, control.version.split("-", 1)[-1])
    control.save_control_to_wapt()
    print("Changing package version to: %s in WAPT\\control" % control.version)

    # Deleting outdated binaries
    remove_outdated_binaries(version)


default_pyscripter_local_ini = r"""[Other Settings]
PyScripter Version=3.6.4.0
Monitor profile=(1920x1024)0:96DPI(True,0,0,1920,1024)
SSHServer=

[Layouts]
Item0=Default
Count=2
Item1=minimalwapt

[Main Form Placement]
ShowCmd=3
Flags=2
PixelsPerInch=96
MinMaxPos(3840x1080)=-1,-1,-1,-1
MinMaxPos=-1,-1,-1,-1
NormPos(3840x1080)=251,197,1691,956
NormPos=251,197,1691,956
MinMaxPos(1920x1024)=-1,-1,-1,-1
NormPos(1920x1024)=251,197,1691,956

[Layouts\minimalwapt\Forms]
FormNames=ProjectExplorerWindow;PyIDEMainForm@LeftDockPanel;PyIDEMainForm@LeftDockPanel_PopupPanel;PyIDEMainForm@RightDockPanel;PyIDEMainForm@RightDockPanel_PopupPanel;PyIDEMainForm@TopDockPanel;PyIDEMainForm@TopDockPanel_PopupPanel;PythonIIForm;PyIDEMainForm@BottomDockPanel;PyIDEMainForm@BottomDockPanel_PopupPanel;PyIDEMainForm;BreakPointsWindow;WatchesWindow;VariablesWindow;CallStackWindow;OutputWindow;MessagesWindow;CodeExplorerWindow;FileExplorerWindow;ToDoWindow;RegExpTesterWindow;UnitTestWindow;FindResultsWindow;

[Layouts\minimalwapt\Forms\ProjectExplorerWindow]
ParentName=PyIDEMainForm@LeftDockPanel
DockTop=20
DockRight=278
DockBottom=592
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=123
LRDockWidth=220
TBDockHeight=220
UnDockWidth=243
UnDockHeight=435
DockClientData=

[Layouts\minimalwapt\Forms\PyIDEMainForm@LeftDockPanel]
ParentName=PyIDEMainForm
DockLeft=1
DockTop=78
DockRight=279
DockBottom=670
LastDockSiteName=
UnDockWidth=200
UnDockHeight=578
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001010000000000000000010100000000011500000050726F6A6563744578706C6F72657257696E646F7701FFFFFFFF

[Layouts\minimalwapt\Forms\PyIDEMainForm@LeftDockPanel_PopupPanel]
ParentName=PyIDEMainForm
DockRight=496
LastDockSiteName=
UnDockWidth=496
Visible=FALSE
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\minimalwapt\Forms\PyIDEMainForm@RightDockPanel]
ParentName=PyIDEMainForm
DockLeft=1919
DockTop=78
DockRight=1919
DockBottom=670
LastDockSiteName=
UnDockHeight=578
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\minimalwapt\Forms\PyIDEMainForm@RightDockPanel_PopupPanel]
ParentName=PyIDEMainForm
DockRight=496
LastDockSiteName=
UnDockWidth=496
Visible=FALSE
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\minimalwapt\Forms\PyIDEMainForm@TopDockPanel]
ParentName=PyIDEMainForm
DockTop=78
DockRight=1920
DockBottom=78
LastDockSiteName=
UnDockWidth=1920
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\minimalwapt\Forms\PyIDEMainForm@TopDockPanel_PopupPanel]
ParentName=PyIDEMainForm
DockRight=496
DockBottom=297
LastDockSiteName=
UnDockWidth=496
UnDockHeight=297
Visible=FALSE
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\minimalwapt\Forms\PythonIIForm]
ParentName=PyIDEMainForm@BottomDockPanel
DockTop=20
DockRight=1920
DockBottom=316
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=736
LRDockWidth=220
TBDockHeight=220
UnDockWidth=1440
UnDockHeight=759
DockClientData=

[Layouts\minimalwapt\Forms\PyIDEMainForm@BottomDockPanel]
ParentName=PyIDEMainForm
DockTop=676
DockRight=1920
DockBottom=992
LastDockSiteName=
UnDockWidth=1920
UnDockHeight=330
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001010000000000000000010100000000010C000000507974686F6E4949466F726D01FFFFFFFF

[Layouts\minimalwapt\Forms\PyIDEMainForm@BottomDockPanel_PopupPanel]
ParentName=PyIDEMainForm
DockRight=496
DockBottom=297
LastDockSiteName=
UnDockWidth=496
UnDockHeight=297
Visible=FALSE
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\minimalwapt\Forms\PyIDEMainForm]
ParentName=
DockLeft=-8
DockTop=-8
DockRight=1928
DockBottom=1048
LastDockSiteName=
LRDockWidth=1936
TBDockHeight=1056
UnDockWidth=1936
UnDockHeight=1056
BorderStyle=2
WindowState=2
DockClientData=

[Layouts\minimalwapt\Forms\BreakPointsWindow]
ParentName=
DockLeft=481
DockTop=590
DockRight=2397
DockBottom=844
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=736
LRDockWidth=220
TBDockHeight=220
UnDockWidth=395
UnDockHeight=271
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\minimalwapt\Forms\WatchesWindow]
ParentName=
DockLeft=674
DockTop=625
DockRight=2590
DockBottom=879
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=736
LRDockWidth=220
TBDockHeight=220
UnDockWidth=776
UnDockHeight=256
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\minimalwapt\Forms\VariablesWindow]
ParentName=
DockLeft=440
DockTop=589
DockRight=2356
DockBottom=843
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=736
LRDockWidth=220
TBDockHeight=220
UnDockWidth=595
UnDockHeight=274
Visible=FALSE
BorderStyle=5
LeftDocked=FALSE
RightDocked=FALSE
DockClientData=

[Layouts\minimalwapt\Forms\CallStackWindow]
ParentName=
DockLeft=469
DockTop=713
DockRight=2385
DockBottom=967
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=736
LRDockWidth=220
TBDockHeight=220
UnDockWidth=620
UnDockHeight=195
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\minimalwapt\Forms\OutputWindow]
ParentName=
DockLeft=457
DockTop=568
DockRight=2373
DockBottom=822
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=736
LRDockWidth=220
TBDockHeight=220
UnDockWidth=568
UnDockHeight=358
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\minimalwapt\Forms\MessagesWindow]
ParentName=
DockLeft=506
DockTop=708
DockRight=2422
DockBottom=962
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=736
LRDockWidth=220
TBDockHeight=220
UnDockWidth=709
UnDockHeight=213
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\minimalwapt\Forms\CodeExplorerWindow]
ParentName=
DockLeft=807
DockTop=207
DockRight=1081
DockBottom=738
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=123
LRDockWidth=220
TBDockHeight=220
UnDockWidth=265
UnDockHeight=333
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\minimalwapt\Forms\FileExplorerWindow]
ParentName=
DockLeft=956
DockTop=167
DockRight=1230
DockBottom=698
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=123
LRDockWidth=220
TBDockHeight=220
UnDockWidth=243
UnDockHeight=466
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\minimalwapt\Forms\ToDoWindow]
ParentName=
DockLeft=377
DockTop=226
DockRight=885
DockBottom=546
LastDockSiteName=Cannot find window
LRDockWidth=220
TBDockHeight=220
UnDockWidth=508
UnDockHeight=320
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\minimalwapt\Forms\RegExpTesterWindow]
ParentName=
DockLeft=356
DockTop=263
DockRight=756
DockBottom=768
LastDockSiteName=Cannot find window
LRDockWidth=220
TBDockHeight=220
UnDockWidth=400
UnDockHeight=505
Visible=FALSE
BorderStyle=5
TopDocked=FALSE
BottomDocked=FALSE
DockClientData=

[Layouts\minimalwapt\Forms\UnitTestWindow]
ParentName=
DockLeft=356
DockTop=263
DockRight=634
DockBottom=741
LastDockSiteName=Cannot find window
LRDockWidth=220
TBDockHeight=220
UnDockWidth=278
UnDockHeight=478
Visible=FALSE
BorderStyle=5
TopDocked=FALSE
BottomDocked=FALSE
DockClientData=

[Layouts\minimalwapt\Forms\FindResultsWindow]
ParentName=
DockLeft=362
DockTop=146
DockRight=981
DockBottom=531
LastDockSiteName=Cannot find window
LRDockWidth=220
TBDockHeight=220
UnDockWidth=619
UnDockHeight=385
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\minimalwapt\Toolbars]
Item0=[Layouts]
Item1=Count=1
Item2=0=minimalwapt
Item3=
Item4=[minimalwapt @ MainMenu]
Item5=Rev=2000
Item6=Visible=1
Item7=DockedTo=TBXDockTop
Item8=LastDock=TBXDockTop
Item9=DockRow=0
Item10=DockPos=0
Item11=FloatLeft=0
Item12=FloatTop=0
Item13=FloatRightX=0
Item14=DisplayMode=0
Item15=
Item16=[minimalwapt @ MainToolBar]
Item17=Rev=2000
Item18=Visible=1
Item19=DockedTo=TBXDockTop
Item20=LastDock=TBXDockTop
Item21=DockRow=1
Item22=DockPos=0
Item23=FloatLeft=0
Item24=FloatTop=0
Item25=FloatRightX=0
Item26=DisplayMode=0
Item27=
Item28=[minimalwapt @ DebugToolbar]
Item29=Rev=2000
Item30=Visible=1
Item31=DockedTo=TBXDockTop
Item32=LastDock=TBXDockTop
Item33=DockRow=1
Item34=DockPos=408
Item35=FloatLeft=0
Item36=FloatTop=0
Item37=FloatRightX=0
Item38=DisplayMode=0
Item39=
Item40=[minimalwapt @ ViewToolbar]
Item41=Rev=2000
Item42=Visible=1
Item43=DockedTo=TBXDockTop
Item44=LastDock=TBXDockTop
Item45=DockRow=1
Item46=DockPos=905
Item47=FloatLeft=941
Item48=FloatTop=95
Item49=FloatRightX=0
Item50=DisplayMode=0
Item51=
Item52=[minimalwapt @ EditorToolbar]
Item53=Rev=2000
Item54=Visible=1
Item55=DockedTo=TBXDockTop
Item56=LastDock=TBXDockTop
Item57=DockRow=1
Item58=DockPos=660
Item59=FloatLeft=0
Item60=FloatTop=0
Item61=FloatRightX=0
Item62=DisplayMode=0
Item63=
Item64=[minimalwapt @ FindToolbar]
Item65=Rev=2000
Item66=Visible=1
Item67=DockedTo=TBXDockTop
Item68=LastDock=TBXDockTop
Item69=DockRow=2
Item70=DockPos=1
Item71=FloatLeft=0
Item72=FloatTop=0
Item73=FloatRightX=0
Item74=DisplayMode=0
Item75=
Item76=[minimalwapt @ UserToolbar]
Item77=Rev=2000
Item78=Visible=0
Item79=DockedTo=TBXDockTop
Item80=LastDock=TBXDockTop
Item81=DockRow=2
Item82=DockPos=310
Item83=FloatLeft=0
Item84=FloatTop=0
Item85=FloatRightX=0
Item86=DisplayMode=0
Item87=
Item88=[minimalwapt @ TabSplitter]
Item89=SplitterRestorePos=60
Item90=
Count=91

[Layouts\Default\Forms]
FormNames=FileExplorerWindow;ProjectExplorerWindow;CodeExplorerWindow;TJvDockTabHostForm_FileExplorerWindow_ProjectExplorerWindow_04504700;PyIDEMainForm@LeftDockPanel;PyIDEMainForm@LeftDockPanel_PopupPanel;PyIDEMainForm@RightDockPanel;PyIDEMainForm@RightDockPanel_PopupPanel;PyIDEMainForm@TopDockPanel;PyIDEMainForm@TopDockPanel_PopupPanel;CallStackWindow;VariablesWindow;WatchesWindow;BreakPointsWindow;OutputWindow;MessagesWindow;PythonIIForm;TJvDockTabHostForm_CallStackWindow_VariablesWindow_04504B20;PyIDEMainForm@BottomDockPanel;PyIDEMainForm@BottomDockPanel_PopupPanel;PyIDEMainForm;ToDoWindow;RegExpTesterWindow;UnitTestWindow;FindResultsWindow;

[Layouts\Default\Forms\FileExplorerWindow]
ParentName=TJvDockTabHostForm_FileExplorerWindow_ProjectExplorerWindow_04504700
DockLeft=2
DockTop=2
DockRight=198
DockBottom=684
LastDockSiteName=Cannot find window
UnDockLeft=398
UnDockTop=201
LRDockWidth=220
TBDockHeight=220
UnDockWidth=243
UnDockHeight=466
DockClientData=

[Layouts\Default\Forms\ProjectExplorerWindow]
ParentName=TJvDockTabHostForm_FileExplorerWindow_ProjectExplorerWindow_04504700
DockLeft=356
DockTop=263
DockRight=599
DockBottom=698
LastDockSiteName=Cannot find window
UnDockLeft=356
UnDockTop=263
LRDockWidth=220
TBDockHeight=220
UnDockWidth=243
UnDockHeight=435
DockClientData=

[Layouts\Default\Forms\CodeExplorerWindow]
ParentName=TJvDockTabHostForm_FileExplorerWindow_ProjectExplorerWindow_04504700
DockLeft=237
DockTop=237
DockRight=502
DockBottom=570
LastDockSiteName=Cannot find window
UnDockLeft=237
UnDockTop=237
LRDockWidth=220
TBDockHeight=220
UnDockWidth=265
UnDockHeight=333
DockClientData=

[Layouts\Default\Forms\TJvDockTabHostForm_FileExplorerWindow_ProjectExplorerWindow_04504700]
ParentName=PyIDEMainForm@LeftDockPanel
DockTop=20
DockRight=200
DockBottom=729
LastDockSiteName=Cannot find window
UnDockLeft=398
UnDockTop=201
LRDockWidth=220
TBDockHeight=884
UnDockWidth=243
UnDockHeight=466
DockFormStyle=2
DockClientData=00000400030000001200000046696C654578706C6F72657257696E646F77010000001500000050726F6A6563744578706C6F72657257696E646F770100000012000000436F64654578706C6F72657257696E646F770100000000000000F6FFFFFF

[Layouts\Default\Forms\PyIDEMainForm@LeftDockPanel]
ParentName=PyIDEMainForm
DockTop=51
DockRight=200
DockBottom=780
LastDockSiteName=
UnDockWidth=200
UnDockHeight=729
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=00000400000000000000000000000000000100000000000100000000010100000000000000000101000000000144000000544A76446F636B546162486F7374466F726D5F46696C654578706C6F72657257696E646F775F50726F6A6563744578706C6F72657257696E646F775F303435303437303001FFFFFFFF

[Layouts\Default\Forms\PyIDEMainForm@LeftDockPanel_PopupPanel]
ParentName=PyIDEMainForm
DockRight=496
LastDockSiteName=
UnDockWidth=496
Visible=FALSE
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\Default\Forms\PyIDEMainForm@RightDockPanel]
ParentName=PyIDEMainForm
DockLeft=1919
DockTop=51
DockRight=1919
DockBottom=780
LastDockSiteName=
UnDockHeight=729
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\Default\Forms\PyIDEMainForm@RightDockPanel_PopupPanel]
ParentName=PyIDEMainForm
DockRight=496
LastDockSiteName=
UnDockWidth=496
Visible=FALSE
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\Default\Forms\PyIDEMainForm@TopDockPanel]
ParentName=PyIDEMainForm
DockTop=51
DockRight=1920
DockBottom=51
LastDockSiteName=
UnDockWidth=1920
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\Default\Forms\PyIDEMainForm@TopDockPanel_PopupPanel]
ParentName=PyIDEMainForm
DockRight=496
DockBottom=283
LastDockSiteName=
UnDockWidth=496
UnDockHeight=283
Visible=FALSE
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\Default\Forms\CallStackWindow]
ParentName=TJvDockTabHostForm_CallStackWindow_VariablesWindow_04504B20
DockLeft=569
DockTop=397
DockRight=1189
DockBottom=592
LastDockSiteName=Cannot find window
UnDockLeft=569
UnDockTop=397
LRDockWidth=220
TBDockHeight=220
UnDockWidth=620
UnDockHeight=195
DockClientData=

[Layouts\Default\Forms\VariablesWindow]
ParentName=TJvDockTabHostForm_CallStackWindow_VariablesWindow_04504B20
DockLeft=2
DockTop=2
DockRight=1918
DockBottom=105
LastDockSiteName=Cannot find window
UnDockLeft=237
UnDockTop=237
LRDockWidth=220
TBDockHeight=220
UnDockWidth=595
UnDockHeight=274
LeftDocked=FALSE
RightDocked=FALSE
DockClientData=

[Layouts\Default\Forms\WatchesWindow]
ParentName=TJvDockTabHostForm_CallStackWindow_VariablesWindow_04504B20
DockLeft=331
DockTop=325
DockRight=1107
DockBottom=581
LastDockSiteName=Cannot find window
UnDockLeft=331
UnDockTop=325
LRDockWidth=220
TBDockHeight=220
UnDockWidth=776
UnDockHeight=256
DockClientData=

[Layouts\Default\Forms\BreakPointsWindow]
ParentName=TJvDockTabHostForm_CallStackWindow_VariablesWindow_04504B20
DockLeft=491
DockTop=381
DockRight=886
DockBottom=652
LastDockSiteName=Cannot find window
UnDockLeft=491
UnDockTop=381
LRDockWidth=220
TBDockHeight=220
UnDockWidth=395
UnDockHeight=271
DockClientData=

[Layouts\Default\Forms\OutputWindow]
ParentName=TJvDockTabHostForm_CallStackWindow_VariablesWindow_04504B20
DockLeft=319
DockTop=173
DockRight=887
DockBottom=531
LastDockSiteName=Cannot find window
UnDockLeft=319
UnDockTop=173
LRDockWidth=220
TBDockHeight=220
UnDockWidth=568
UnDockHeight=358
DockClientData=

[Layouts\Default\Forms\MessagesWindow]
ParentName=TJvDockTabHostForm_CallStackWindow_VariablesWindow_04504B20
DockLeft=259
DockTop=257
DockRight=968
DockBottom=470
LastDockSiteName=Cannot find window
UnDockLeft=259
UnDockTop=257
LRDockWidth=220
TBDockHeight=220
UnDockWidth=709
UnDockHeight=213
DockClientData=

[Layouts\Default\Forms\PythonIIForm]
ParentName=TJvDockTabHostForm_CallStackWindow_VariablesWindow_04504B20
DockLeft=2
DockTop=2
DockRight=1918
DockBottom=105
LastDockSiteName=Cannot find window
UnDockLeft=52
UnDockTop=52
LRDockWidth=220
TBDockHeight=220
UnDockWidth=1440
UnDockHeight=717
DockClientData=

[Layouts\Default\Forms\TJvDockTabHostForm_CallStackWindow_VariablesWindow_04504B20]
ParentName=PyIDEMainForm@BottomDockPanel
DockTop=20
DockRight=1920
DockBottom=150
LastDockSiteName=Cannot find window
UnDockLeft=569
UnDockTop=397
LRDockWidth=1920
TBDockHeight=220
UnDockWidth=620
UnDockHeight=195
DockFormStyle=2
DockClientData=00000400070000000F00000043616C6C537461636B57696E646F77010000000F0000005661726961626C657357696E646F77010000000D0000005761746368657357696E646F770100000011000000427265616B506F696E747357696E646F77010000000C0000004F757470757457696E646F77010000000E0000004D6573736167657357696E646F77010000000C000000507974686F6E4949466F726D0100000006000000F6FFFFFF

[Layouts\Default\Forms\PyIDEMainForm@BottomDockPanel]
ParentName=PyIDEMainForm
DockTop=786
DockRight=1920
DockBottom=936
LastDockSiteName=
UnDockWidth=1920
UnDockHeight=150
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001010000000000000000010100000000013B000000544A76446F636B546162486F7374466F726D5F43616C6C537461636B57696E646F775F5661726961626C657357696E646F775F303435303442323001FFFFFFFF

[Layouts\Default\Forms\PyIDEMainForm@BottomDockPanel_PopupPanel]
ParentName=PyIDEMainForm
DockRight=496
DockBottom=283
LastDockSiteName=
UnDockWidth=496
UnDockHeight=283
Visible=FALSE
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\Default\Forms\PyIDEMainForm]
ParentName=
DockLeft=-8
DockTop=-8
DockRight=1928
DockBottom=992
LastDockSiteName=
LRDockWidth=1936
TBDockHeight=1000
UnDockWidth=1936
UnDockHeight=1000
BorderStyle=2
WindowState=2
DockClientData=

[Layouts\Default\Forms\ToDoWindow]
ParentName=
DockLeft=377
DockTop=226
DockRight=885
DockBottom=546
LastDockSiteName=Cannot find window
LRDockWidth=220
TBDockHeight=220
UnDockWidth=508
UnDockHeight=320
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\Default\Forms\RegExpTesterWindow]
ParentName=
DockLeft=356
DockTop=263
DockRight=756
DockBottom=768
LastDockSiteName=Cannot find window
LRDockWidth=220
TBDockHeight=220
UnDockWidth=400
UnDockHeight=505
Visible=FALSE
BorderStyle=5
TopDocked=FALSE
BottomDocked=FALSE
DockClientData=

[Layouts\Default\Forms\UnitTestWindow]
ParentName=
DockLeft=356
DockTop=263
DockRight=634
DockBottom=741
LastDockSiteName=Cannot find window
LRDockWidth=220
TBDockHeight=220
UnDockWidth=278
UnDockHeight=478
Visible=FALSE
BorderStyle=5
TopDocked=FALSE
BottomDocked=FALSE
DockClientData=

[Layouts\Default\Forms\FindResultsWindow]
ParentName=
DockLeft=362
DockTop=146
DockRight=981
DockBottom=531
LastDockSiteName=Cannot find window
LRDockWidth=220
TBDockHeight=220
UnDockWidth=619
UnDockHeight=385
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\Default\Toolbars]
Item0=[Layouts]
Item1=Count=1
Item2=0=Default
Item3=
Item4=[Default @ MainMenu]
Item5=Rev=2000
Item6=Visible=1
Item7=DockedTo=TBXDockTop
Item8=LastDock=TBXDockTop
Item9=DockRow=0
Item10=DockPos=0
Item11=FloatLeft=0
Item12=FloatTop=0
Item13=FloatRightX=0
Item14=DisplayMode=0
Item15=
Item16=[Default @ MainToolBar]
Item17=Rev=2000
Item18=Visible=1
Item19=DockedTo=TBXDockTop
Item20=LastDock=TBXDockTop
Item21=DockRow=1
Item22=DockPos=-6
Item23=FloatLeft=0
Item24=FloatTop=0
Item25=FloatRightX=0
Item26=DisplayMode=0
Item27=
Item28=[Default @ DebugToolbar]
Item29=Rev=2000
Item30=Visible=1
Item31=DockedTo=TBXDockTop
Item32=LastDock=TBXDockTop
Item33=DockRow=1
Item34=DockPos=361
Item35=FloatLeft=0
Item36=FloatTop=0
Item37=FloatRightX=0
Item38=DisplayMode=0
Item39=
Item40=[Default @ ViewToolbar]
Item41=Rev=2000
Item42=Visible=1
Item43=DockedTo=TBXDockTop
Item44=LastDock=TBXDockTop
Item45=DockRow=1
Item46=DockPos=728
Item47=FloatLeft=0
Item48=FloatTop=0
Item49=FloatRightX=0
Item50=DisplayMode=0
Item51=
Item52=[Default @ EditorToolbar]
Item53=Rev=2000
Item54=Visible=1
Item55=DockedTo=TBXDockTop
Item56=LastDock=TBXDockTop
Item57=DockRow=1
Item58=DockPos=574
Item59=FloatLeft=0
Item60=FloatTop=0
Item61=FloatRightX=0
Item62=DisplayMode=0
Item63=
Item64=[Default @ FindToolbar]
Item65=Rev=2000
Item66=Visible=0
Item67=DockedTo=TBXDockTop
Item68=LastDock=TBXDockTop
Item69=DockRow=2
Item70=DockPos=1
Item71=FloatLeft=0
Item72=FloatTop=0
Item73=FloatRightX=0
Item74=DisplayMode=0
Item75=
Item76=[Default @ UserToolbar]
Item77=Rev=2000
Item78=Visible=0
Item79=DockedTo=TBXDockTop
Item80=LastDock=TBXDockTop
Item81=DockRow=2
Item82=DockPos=310
Item83=FloatLeft=0
Item84=FloatTop=0
Item85=FloatRightX=0
Item86=DisplayMode=0
Item87=
Item88=[Default @ TabSplitter]
Item89=SplitterRestorePos=60
Item90=
Count=91

[Layouts\Current\Forms]
FormNames=ProjectExplorerWindow;PyIDEMainForm@LeftDockPanel;PyIDEMainForm@LeftDockPanel_PopupPanel;PyIDEMainForm@RightDockPanel;PyIDEMainForm@RightDockPanel_PopupPanel;PyIDEMainForm@TopDockPanel;PyIDEMainForm@TopDockPanel_PopupPanel;PythonIIForm;PyIDEMainForm@BottomDockPanel;PyIDEMainForm@BottomDockPanel_PopupPanel;PyIDEMainForm;CallStackWindow;VariablesWindow;WatchesWindow;BreakPointsWindow;OutputWindow;MessagesWindow;CodeExplorerWindow;FileExplorerWindow;ToDoWindow;RegExpTesterWindow;UnitTestWindow;FindResultsWindow;

[Layouts\Current\Forms\ProjectExplorerWindow]
ParentName=PyIDEMainForm@LeftDockPanel
DockTop=20
DockRight=278
DockBottom=536
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=123
LRDockWidth=220
TBDockHeight=220
UnDockWidth=243
UnDockHeight=435
DockClientData=

[Layouts\Current\Forms\PyIDEMainForm@LeftDockPanel]
ParentName=PyIDEMainForm
DockTop=78
DockRight=278
DockBottom=614
LastDockSiteName=
UnDockWidth=200
UnDockHeight=578
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001010000000000000000010100000000011500000050726F6A6563744578706C6F72657257696E646F7701FFFFFFFF

[Layouts\Current\Forms\PyIDEMainForm@LeftDockPanel_PopupPanel]
ParentName=PyIDEMainForm
DockRight=496
LastDockSiteName=
UnDockWidth=496
Visible=FALSE
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\Current\Forms\PyIDEMainForm@RightDockPanel]
ParentName=PyIDEMainForm
DockLeft=1919
DockTop=78
DockRight=1919
DockBottom=614
LastDockSiteName=
UnDockHeight=578
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\Current\Forms\PyIDEMainForm@RightDockPanel_PopupPanel]
ParentName=PyIDEMainForm
DockRight=496
LastDockSiteName=
UnDockWidth=496
Visible=FALSE
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\Current\Forms\PyIDEMainForm@TopDockPanel]
ParentName=PyIDEMainForm
DockTop=78
DockRight=1920
DockBottom=78
LastDockSiteName=
UnDockWidth=1920
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\Current\Forms\PyIDEMainForm@TopDockPanel_PopupPanel]
ParentName=PyIDEMainForm
DockRight=496
DockBottom=283
LastDockSiteName=
UnDockWidth=496
UnDockHeight=297
Visible=FALSE
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\Current\Forms\PythonIIForm]
ParentName=PyIDEMainForm@BottomDockPanel
DockTop=20
DockRight=1920
DockBottom=316
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=736
LRDockWidth=220
TBDockHeight=220
UnDockWidth=1440
UnDockHeight=717
DockClientData=

[Layouts\Current\Forms\PyIDEMainForm@BottomDockPanel]
ParentName=PyIDEMainForm
DockTop=620
DockRight=1920
DockBottom=936
LastDockSiteName=
UnDockWidth=1920
UnDockHeight=330
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001010000000000000000010100000000010C000000507974686F6E4949466F726D01FFFFFFFF

[Layouts\Current\Forms\PyIDEMainForm@BottomDockPanel_PopupPanel]
ParentName=PyIDEMainForm
DockRight=496
DockBottom=283
LastDockSiteName=
UnDockWidth=496
UnDockHeight=297
Visible=FALSE
DockFormStyle=3
CanDocked=FALSE
EachOtherDocked=FALSE
LeftDocked=FALSE
TopDocked=FALSE
RightDocked=FALSE
BottomDocked=FALSE
CustomDocked=FALSE
DockClientData=0000040000000000000000000000000000010000000000010000000001FFFFFFFF

[Layouts\Current\Forms\PyIDEMainForm]
ParentName=
DockLeft=-8
DockTop=-8
DockRight=1928
DockBottom=992
LastDockSiteName=
LRDockWidth=1936
TBDockHeight=1056
UnDockWidth=1936
UnDockHeight=1056
BorderStyle=2
WindowState=2
DockClientData=

[Layouts\Current\Forms\CallStackWindow]
ParentName=
DockLeft=469
DockTop=713
DockRight=2385
DockBottom=967
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=736
LRDockWidth=220
TBDockHeight=220
UnDockWidth=620
UnDockHeight=195
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\Current\Forms\VariablesWindow]
ParentName=
DockLeft=440
DockTop=589
DockRight=2356
DockBottom=843
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=736
LRDockWidth=220
TBDockHeight=220
UnDockWidth=595
UnDockHeight=274
Visible=FALSE
BorderStyle=5
LeftDocked=FALSE
RightDocked=FALSE
DockClientData=

[Layouts\Current\Forms\WatchesWindow]
ParentName=
DockLeft=674
DockTop=625
DockRight=2590
DockBottom=879
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=736
LRDockWidth=220
TBDockHeight=220
UnDockWidth=776
UnDockHeight=256
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\Current\Forms\BreakPointsWindow]
ParentName=
DockLeft=481
DockTop=590
DockRight=2397
DockBottom=844
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=736
LRDockWidth=220
TBDockHeight=220
UnDockWidth=395
UnDockHeight=271
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\Current\Forms\OutputWindow]
ParentName=
DockLeft=457
DockTop=568
DockRight=2373
DockBottom=822
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=736
LRDockWidth=220
TBDockHeight=220
UnDockWidth=568
UnDockHeight=358
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\Current\Forms\MessagesWindow]
ParentName=
DockLeft=506
DockTop=708
DockRight=2422
DockBottom=962
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=736
LRDockWidth=220
TBDockHeight=220
UnDockWidth=709
UnDockHeight=213
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\Current\Forms\CodeExplorerWindow]
ParentName=
DockLeft=807
DockTop=207
DockRight=1081
DockBottom=738
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=123
LRDockWidth=220
TBDockHeight=220
UnDockWidth=265
UnDockHeight=333
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\Current\Forms\FileExplorerWindow]
ParentName=
DockLeft=956
DockTop=167
DockRight=1230
DockBottom=698
LastDockSiteName=Cannot find window
UnDockLeft=2
UnDockTop=123
LRDockWidth=220
TBDockHeight=220
UnDockWidth=243
UnDockHeight=466
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\Current\Forms\ToDoWindow]
ParentName=
DockLeft=377
DockTop=226
DockRight=885
DockBottom=546
LastDockSiteName=Cannot find window
LRDockWidth=220
TBDockHeight=220
UnDockWidth=508
UnDockHeight=320
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\Current\Forms\RegExpTesterWindow]
ParentName=
DockLeft=356
DockTop=263
DockRight=756
DockBottom=768
LastDockSiteName=Cannot find window
LRDockWidth=220
TBDockHeight=220
UnDockWidth=400
UnDockHeight=505
Visible=FALSE
BorderStyle=5
TopDocked=FALSE
BottomDocked=FALSE
DockClientData=

[Layouts\Current\Forms\UnitTestWindow]
ParentName=
DockLeft=356
DockTop=263
DockRight=634
DockBottom=741
LastDockSiteName=Cannot find window
LRDockWidth=220
TBDockHeight=220
UnDockWidth=278
UnDockHeight=478
Visible=FALSE
BorderStyle=5
TopDocked=FALSE
BottomDocked=FALSE
DockClientData=

[Layouts\Current\Forms\FindResultsWindow]
ParentName=
DockLeft=362
DockTop=146
DockRight=981
DockBottom=531
LastDockSiteName=Cannot find window
LRDockWidth=220
TBDockHeight=220
UnDockWidth=619
UnDockHeight=385
Visible=FALSE
BorderStyle=5
DockClientData=

[Layouts\Current\Toolbars]
Item0=[Layouts]
Item1=Count=1
Item2=0=Current
Item3=
Item4=[Current @ MainMenu]
Item5=Rev=2000
Item6=Visible=1
Item7=DockedTo=TBXDockTop
Item8=LastDock=TBXDockTop
Item9=DockRow=0
Item10=DockPos=0
Item11=FloatLeft=0
Item12=FloatTop=0
Item13=FloatRightX=0
Item14=DisplayMode=0
Item15=
Item16=[Current @ MainToolBar]
Item17=Rev=2000
Item18=Visible=1
Item19=DockedTo=TBXDockTop
Item20=LastDock=TBXDockTop
Item21=DockRow=1
Item22=DockPos=0
Item23=FloatLeft=0
Item24=FloatTop=0
Item25=FloatRightX=0
Item26=DisplayMode=0
Item27=
Item28=[Current @ DebugToolbar]
Item29=Rev=2000
Item30=Visible=1
Item31=DockedTo=TBXDockTop
Item32=LastDock=TBXDockTop
Item33=DockRow=1
Item34=DockPos=408
Item35=FloatLeft=0
Item36=FloatTop=0
Item37=FloatRightX=0
Item38=DisplayMode=0
Item39=
Item40=[Current @ ViewToolbar]
Item41=Rev=2000
Item42=Visible=1
Item43=DockedTo=TBXDockTop
Item44=LastDock=TBXDockTop
Item45=DockRow=1
Item46=DockPos=905
Item47=FloatLeft=941
Item48=FloatTop=95
Item49=FloatRightX=0
Item50=DisplayMode=0
Item51=
Item52=[Current @ EditorToolbar]
Item53=Rev=2000
Item54=Visible=1
Item55=DockedTo=TBXDockTop
Item56=LastDock=TBXDockTop
Item57=DockRow=1
Item58=DockPos=660
Item59=FloatLeft=0
Item60=FloatTop=0
Item61=FloatRightX=0
Item62=DisplayMode=0
Item63=
Item64=[Current @ FindToolbar]
Item65=Rev=2000
Item66=Visible=1
Item67=DockedTo=TBXDockTop
Item68=LastDock=TBXDockTop
Item69=DockRow=2
Item70=DockPos=1
Item71=FloatLeft=0
Item72=FloatTop=0
Item73=FloatRightX=0
Item74=DisplayMode=0
Item75=
Item76=[Current @ UserToolbar]
Item77=Rev=2000
Item78=Visible=0
Item79=DockedTo=TBXDockTop
Item80=LastDock=TBXDockTop
Item81=DockRow=2
Item82=DockPos=310
Item83=FloatLeft=0
Item84=FloatTop=0
Item85=FloatRightX=0
Item86=DisplayMode=0
Item87=
Item88=[Current @ TabSplitter]
Item89=SplitterRestorePos=60
Item90=
Count=91

[PythonVersions-x86\Custom Versions]
Path0=WAPT=C:\Program Files (x86)\wapt
Count=1

[PythonVersions-x86]
InstallPath=C:\Program Files (x86)\wapt"""
