# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *


def update_package():
    
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
        
    download_dict = {
        "windows-x64": "https://the.earth.li/~sgtatham/putty/latest/w64/",
        "windows-x86": "https://the.earth.li/~sgtatham/putty/latest/w32/",
        "windows-arm64": "https://the.earth.li/~sgtatham/putty/latest/wa64/",
    }
    architecture = ensure_list(control.architecture)[0]
    if architecture =='arm':
        architecture='arm64'
        
    url = download_dict["windows-" + architecture]
    
    # Getting latest version from official sources
    print("URL used is: %s" % url)
    for bs_search in bs_find_all(url, "a", "href", proxies=proxies):
        if "installer.msi" in bs_search["href"]:
            latest_bin = bs_search["href"]
            version = latest_bin.rsplit("-")[-2]
            download_url = url + bs_search["href"]
            break

    # Downloading latest binaries
    print("Latest %s version is: %s" % (control.name, version))
    print("Download URL is: %s" % download_url)
    
    print("Downloading: %s" % latest_bin)
    wget(download_url, latest_bin, proxies=proxies)
    
    version_from_file = get_version_from_binary(latest_bin)
    
    control.set_software_version(version_from_file)
    control.save_control_to_wapt()

