# -*- coding: utf-8 -*-
from setuphelpers import *
import glob
import shutil
import os

app_name = "Proxyman"
app_dir = makepath(programfiles, app_name)
userprofile = os.environ['USERPROFILE']
source_install_dir = makepath(userprofile, "AppData", "Local", "Programs", "proxyman")

def install():
    bin_name = glob.glob('*.exe')[0]
    app_path = makepath(app_dir, bin_name)

    # Installing software
    killalltasks(ensure_list(control.impacted_process))

    if isdir(app_dir) and force:
        remove_tree(app_dir)

    mkdirs(app_dir)

    while True:
        try:
            run(f'"{bin_name}" /S')
            break
        except:
            if not params.get("install_with_luti", False):
                raise
            else:
                time.sleep(10)
    

    # Copying all files from the installation directory to Program Files
    if isdir(source_install_dir):
        shutil.copytree(source_install_dir, app_dir, dirs_exist_ok=True)
        remove_tree(source_install_dir)

    # Creating custom shortcuts
    create_desktop_shortcut(app_name, target=makepath(app_dir, "Proxyman.exe"))
    create_programs_menu_shortcut(app_name, target=makepath(app_dir, "Proxyman.exe"))

def uninstall():
    # Uninstalling software
    killalltasks(ensure_list(control.impacted_process))

    if isdir(app_dir):
        remove_tree(app_dir)

    # Removing shortcuts
    remove_desktop_shortcut(app_name)
    remove_programs_menu_shortcut(app_name)
