# -*- coding: utf-8 -*-
from setuphelpers import *

"""
 {
   "key":"Proton Mail Bridge 3.13.0",
   "name":"Proton Mail Bridge",
   "version":"3.13.0",
   "install_date":"",
   "install_location":"C:\\Program Files\\Proton AG\\Proton Mail Bridge\\",
   "uninstall_string":"C:\\ProgramData\\Caphyon\\Advanced Installer\\{7EC0ECB3-08A2-49FB-A098-94F01D959FC8}\\Bridge-Installer.exe /i {7EC0ECB3-08A2-49FB-A098-94F01D959FC8} AI_UNINSTALLER_CTP=1",
   "publisher":"Proton AG",
   "system_component":0,
   "win64":true
  },
  {
   "key":"{7EC0ECB3-08A2-49FB-A098-94F01D959FC8}",
   "name":"Proton Mail Bridge",
   "version":"3.13.0",
   "install_date":"2024-10-09 00:00:00",
   "install_location":"C:\\Program Files\\Proton AG\\Proton Mail Bridge\\",
   "uninstall_string":"MsiExec.exe /I{7EC0ECB3-08A2-49FB-A098-94F01D959FC8}",
   "publisher":"Proton AG",
   "system_component":0,
   "win64":true
  }
"""

def install():
  bin_name = glob.glob("Bridge-Installer.exe")[0]

  install_exe_if_needed(
      bin_name,
      silentflags="/quiet",
      key=f'Proton Mail Bridge {control.get_software_version()}',
      min_version=control.get_software_version()
  )

  uninstallkey.clear()

def uninstall():

  killalltasks(ensure_list(control.impacted_process))

  for soft in installed_softwares(name='Proton Mail Bridge'):
    if 'MsiExec' in soft['uninstall_string']:
      run(uninstall_cmd(soft['key']))