# -*- coding: utf-8 -*-
from setuphelpers import *

# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls
app_name = "Process Explorer"
app_dir = makepath(programfiles32, app_name)


def install():
    # Declaring local variables
    package_version = control.get_software_version()
    bin_name = glob.glob("*ProcessExplorer*.zip")[0]
    if isARM64():
        app_path = makepath(app_dir, "procexp64a.exe")
    elif iswin64():
        app_path = makepath(app_dir, "procexp64.exe")
    else:
        app_path = makepath(app_dir, "procexp.exe")

    # Getting installed software version
    if isfile(app_path):
        installed_version = get_version_from_binary(app_path)
    else:
        installed_version = None

    # Installing software
    print("Installing: %s" % app_name)
    if installed_version is None or installed_version < package_version or force:
        killalltasks(control.get_impacted_process_list())
        if isdir(app_dir):
            remove_tree(app_dir)
        mkdirs(app_dir)
        print("Extracting: %s to: %s" % (bin_name, app_dir))
        unzip(bin_name, app_dir)

        # Creating shortcuts
        create_desktop_shortcut(app_name, app_path)
        create_programs_menu_shortcut(app_name, app_path)

        # Adding software to "list-registry"
        register_windows_uninstall(control, win64app=False)
    else:
        print("%s already installed. Skipping" % app_name)


def uninstall():
    # Uninstalling software
    killalltasks(control.get_impacted_process_list())
    if isdir(app_dir):
        remove_tree(app_dir)
    unregister_uninstall(app_name)

    # Removing shortcuts
    remove_desktop_shortcut(app_name)
    remove_programs_menu_shortcut(app_name)


def audit():
    # Declaring local variables
    package_version = control.get_software_version()
    if isARM64():
        app_path = makepath(app_dir, "procexp64a.exe")
    elif iswin64():
        app_path = makepath(app_dir, "procexp64.exe")
    else:
        app_path = makepath(app_dir, "procexp.exe")

    # Getting installed software version
    if isfile(app_path):
        installed_version = get_version_from_binary(app_path)
    else:
        installed_version = None

    # Auditing software
    print("Auditing: %s" % control.package)
    if installed_version is None or Version(installed_version) < Version(package_version):
        print("%s version is incorrect (%s)" % (app_name, installed_version))
        return "ERROR"
    else:
        print("%s is installed in correct version (%s)" % (app_name, installed_version))
        return "OK"
