# -*- coding: utf-8 -*-
##################################################
# This file is part of WAPT Enterprise
# All right reserved, (c) Tranquil IT Systems 2024
# For more information please refer to
# https://wapt.tranquil.it/store/licences.html
##################################################
from setuphelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()
    app_name = control.name

    api_url = "https://api.github.com/repos/prey/prey-node-client/releases/latest"
    dict_arch = {
        "x64" :"-x64.msi",
        "x86" : '-x86.msi'
    }


    releases_dict = wgets(api_url, proxies=proxies, as_json=True)
    for asset in releases_dict["assets"]:
        if asset["browser_download_url"].endswith('.msi') and dict_arch[control.architecture] in asset["browser_download_url"]:
            download_url = asset["browser_download_url"]
            latest_bin = asset["name"]
            latest_bin_extension = latest_bin.rsplit('.', 1)[-1]
            version = releases_dict["tag_name"].replace('v','')
            break

    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated