# -*- coding: utf-8 -*-
from setuphelpers import *
import re


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    update_dict = {
        "x64" :"win-intel64.zip",
        "x86"  : "win-intel32.zip"
    }
    git_repo = "praat/praat"
    url_api = "https://api.github.com/repos/%s/releases/latest" % git_repo
    # Getting latest version information from official sources
    print("API used is: %s" % url_api)
    json_load = json.loads(wgets(url_api, proxies=proxies))
    for download in json_load["assets"]:
        if download["browser_download_url"].endswith(".zip") and update_dict[control.architecture] in download["browser_download_url"] :
            url_dl = download["browser_download_url"]
            version = json_load["tag_name"].replace("v","").replace("a","")
            filename = download["name"]
            break

    if not isfile(filename):
        package_updated = True
        wget(url_dl, filename, proxies=proxies)

    # nettoyer les fichiers temporaires
    for f in glob.glob("*.zip"):
        if f != filename:
            remove_file(f)
    
    control.set_software_version(version)
    control.save_control_to_wapt()
