# -*- coding: utf-8 -*-
from platform import architecture
from setuphelpers import *
import json


def update_package():
    # Declaring local variables
    bin_contains = "PowerToysSetup"
    result = False
    proxies = get_proxies_from_wapt_console()
    architecture = control.architecture
    if not proxies:
        proxies = get_proxies()
    app_name = control.name
    git_repo = "microsoft/PowerToys"
    url_api = "https://api.github.com/repos/%s/releases/latest" % git_repo
    bin_name_sub = "PowerToysSetup%s.exe"
    
    # Getting latest version information from official sources
    print("API used is: %s" % url_api)
    json_load = json.loads(wgets(url_api, proxies=proxies))

    for download in json_load["assets"]:
        if bin_contains in download["name"] and architecture in download["name"]:
            url_dl = download["browser_download_url"]
            version = json_load["tag_name"].replace("v", "")
            latest_bin = download["name"]
            break

    version = latest_bin.split('-')[1]

    print("Latest %s version is: %s" % (app_name, version))
    print("Download URL is: %s" % url_dl)

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(url_dl, latest_bin, proxies=proxies)
        result = True
        
    control.set_software_version(version)
    control.save_control_to_wapt()

    for f in glob.glob('*.exe'):
        if f != latest_bin:
            remove_file(f)

    # Validating update-package-sources
    return result
