# -*- coding: utf-8 -*-
from platform import architecture
from setuphelpers import *

r"""
UninstallKey                           Software                                                              Version             Uninstallstring
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
{DEE6FAF3-AD8C-44B3-9F6A-B5D48178767D} PowerToys (Preview)                                                   0.55.2              MsiExec.exe /X{DEE6FAF3-AD8C-44B3-9F6A-B5D48178767D}
{dc8e33af-8074-4443-86b3-3ba097834e4d} PowerToys (Preview) x64                                               0.55.2              "C:\ProgramData\Package Cache\{dc8e33af-8074-4443-86b3-3ba097834e4d}\PowerToysSetup-0.55.2-x64.exe"  /uninstall

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls

# app_uninstallkey = '{916D6700-2270-4DD8-B1F9-BC7F951B49F3}'


def install():
    # Declaring local variables
    bin_name = glob.glob("*.exe")[0]
    # Installing the package
    print("Installing: %s" % bin_name)
    install_exe_if_needed(
        bin_name,
        silentflags="/quiet",
        name="PowerToys",
        min_version=control.get_software_version(),
    )


def uninstall():
    # Uninstalling the software
    for to_uninstall in installed_softwares("PowerToys"):
        print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
        killalltasks(control.impacted_process.split(","))
        run(uninstall_cmd(to_uninstall["key"]))
        wait_uninstallkey_absent(to_uninstall["key"])
