# -*- coding: utf-8 -*-
from setuphelpers import *

# Installation procedure: https://docs.microsoft.com/powershell/scripting/install/installing-powershell-on-windows
# silent_args = 'ADD_EXPLORER_CONTEXT_MENU_OPENPOWERSHELL=0 REGISTER_MANIFEST=0 ENABLE_PSREMOTING=0'


def install():
    package_prefix = control.package.split("-", 1)[0]
    pkg_pwsh5 = package_prefix + "-" + "powershell5"
    pkg_pwsh_core = package_prefix + "-" + "powershell-core"

    # Older Windows versions depends on PowerShell 5
    if windows_version() < WindowsVersions.Windows10:
        if not WAPT.is_installed(pkg_pwsh5):
            if WAPT.is_available(pkg_pwsh5):
                print("Installing: %s" % pkg_pwsh5)
                WAPT.install(pkg_pwsh5)
                WAPT.audit(pkg_pwsh5)
            else:
                error("ERROR: %s package not found on the repo, please import it" % pkg_pwsh5)
    else:
        # W10+ part
        if WAPT.is_installed(pkg_pwsh5):
            print("Forgetting: %s" % pkg_pwsh5)
            WAPT.forget_packages(pkg_pwsh5)

    # Forget Powershell Core
    if WAPT.is_installed(pkg_pwsh_core):
        print("Forgetting: %s" % pkg_pwsh_core)
        WAPT.forget_packages(pkg_pwsh_core)

    # Installing package
    bin_name = glob.glob("PowerShell-*.msi")[0]
    install_msi_if_needed(
        bin_name,
        min_version=control.get_software_version(),
    )

    # Disabling update check and telemetry
    set_environ_variable("POWERSHELL_CLI_TELEMETRY_OPTOUT", "1")
    set_environ_variable("POWERSHELL_TELEMETRY_OPTOUT", "1")
    set_environ_variable("POWERSHELL_UPDATECHECK", "Off")
    set_environ_variable("POWERSHELL_UPDATECHECK_OPTOUT", "1")
    set_environ_variable("DOTNET_CLI_TELEMETRY_OPTOUT", "1")
    set_environ_variable("DOTNET_TELEMETRY_OPTOUT", "1")
