# -*- coding: utf-8 -*-
from setuphelpers import *

# Installation procedure: https://docs.microsoft.com/powershell/scripting/install/installing-powershell-on-linux

# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls
package_name = "powershell"
lts_package_name = "powershell-lts"


def install():
    # Declaring specific app values
    package_version = control.get_software_version()
    bin_name = glob.glob("*powershell-*.rpm")[0]

    # Uninstalling the LTS version of the software
    print("Uninstalling package: %s" % lts_package_name)
    uninstall_yum(lts_package_name)

    # Installing the software
    print("Installing: %s" % bin_name)
    install_yum(bin_name)


def uninstall():
    # Uninstalling the software
    print("Uninstalling package: %s" % package_name)
    uninstall_yum(package_name)
