# -*- coding: utf-8 -*-
from setuphelpers import *


app_name = "podman"
app_dir = makepath(programfiles, app_name)
app_path = makepath(app_dir, f"{app_name}.exe")


def install():
    # Declaring local variables
    zip_name = glob.glob("podman-*-windows_amd64.zip")[0]

    unzipped_dir = app_name
    version = control.get_software_version()
    app_install_dir = makepath(programfiles, f"podman-{version}")

    # Installing software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_install_dir) and force:
        remove_tree(app_install_dir)
    print("Extracting: %s to: %s" % (zip_name, app_install_dir))
    unzip(zip_name, makepath(programfiles))

def uninstall():
    version = control.get_software_version()
    app_install_dir = makepath(programfiles, f"podman-{version}")

    # Uninstalling software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_install_dir):
        remove_tree(app_install_dir)
