# -*- coding: utf-8 -*-
from setuphelpers import *

bin_path = makepath("/","usr","local","bin")
app_path = "/opt/podman"

def install():
    extract_path = glob.glob("podman-remote-static-linux_amd64.tar.gz")[0]
    # Removing previous symlink
    if isfile(f"{bin_path}/podman"):
        remove_file(f"{bin_path}/podman")

    # Removing previous directory
    if isdir(app_path):
        remove_tree('/opt/podman')

    mkdirs(app_path)
    run(f"tar -xf {extract_path} -C /opt/podman")

    # Creation of symlink
    os.symlink(f'{app_path}/bin/podman-remote-static-linux_amd64',f'{bin_path}/podman')
    
    if isdir(extract_path):
        remove_tree(extract_path)

def uninstall():
    # Removing of symlink
    if isfile(f"{bin_path}/podman"):
        remove_file(f"{bin_path}/podman")
    # Removing of the software
    if isdir('/opt/podman'):
        remove_tree('/opt/podman')



