# -*- coding: utf-8 -*-
from setuphelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    url = "https://windows.php.net/download"
    arch_dict = {"x64": "-Win32-vs17-x64", "x86": "-Win32-vs17-x86"}

    # Getting latest version from official sources
    print("URL used is: %s" % url)
    for bs_search in bs_find_all(url, "a", proxies=proxies):
        if bs_search.text == "Zip":
            if arch_dict[control.architecture] in bs_search["href"] and not "-nts-" in bs_search["href"]:
                download_url = "https://windows.php.net" + bs_search["href"]
                latest_bin = bs_search["href"].split("/")[-1]
                version = latest_bin.split("-")[1]
                break

    # Downloading latest binaries
    print("Latest %s version is: %s" % (app_name, version))
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(version, "zip")

    # Validating or not update-package-sources
    return package_updated
