# -*- coding: utf-8 -*-
from setuphelpers import *

"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls
bin_contains = "pgadmin4-"
silent_args = "/VERYSILENT /SUPPRESSMSGBOXES /NORESTART /SP- /ALLUSERS"


def install():
    # Declaring local variables
    package_version = control.get_software_version()
    bin_name = glob.glob("*%s*.exe" % bin_contains)[0]
    app_uninstallkey = "pgAdmin 4v%s_is1" % package_version.split(".")[0]

    for soft in installed_softwares("pgAdmin 4"):
        if Version(soft["version"]) < Version(package_version):
            run(uninstall_cmd(soft["key"]))

    # Installing the software
    print("Installing: %s" % bin_name)
    install_exe_if_needed(
        bin_name,
        silentflags=silent_args,
        key=app_uninstallkey,
        min_version=package_version,
        timeout=600,
    )
