# -*- coding: utf-8 -*-
from setuphelpers import *


def update_package():
    # Declaring local variables
    result = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    url = "https://www.pgadmin.org/download/pgadmin-4-windows"
    if control.architecture == "x64":
        sub_bin_name = "pgadmin4-%s-x64.exe"
    else:
        sub_bin_name = "pgadmin4-%s-x86.exe"

    # Getting latest version from official sources
    print("URL used is: %s" % url)
    for bs_search in bs_find_all(url, "a", "class", "dropdown-item", proxies=proxies):
        if bs_search["href"].startswith("/docs/pgadmin4/"):
            version = bs_search["href"].split("/")[-2]
            break

    # https://ftp.postgresql.org/pub/pgadmin/pgadmin4/v4.23/windows/pgadmin4-4.23-x64.exe
    latest_bin = sub_bin_name % version
    download_url = "https://ftp.postgresql.org/pub/pgadmin/pgadmin4/v%s/windows/%s" % (version, latest_bin)

    print("Latest %s version is: %s" % (app_name, version))
    print("Download URL is: %s" % download_url)

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)

        # Checking version from file
        version_from_file = get_product_props(latest_bin)["ProductVersion"]
        if Version(version) != Version(version_from_file) and version_from_file != "":
            print("Changing version to the version number of the binary (from: %s to: %s)" % (version, version_from_file))
            os.rename(latest_bin, sub_bin_name % version_from_file)
            version = version_from_file
        else:
            print("Binary file version corresponds to online version")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        result = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.version = "%s-%s" % (Version(version), control.version.split("-", 1)[-1])
    # control.set_software_version(version)
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(version)

    # Validating or not update-package-sources
    return result
