# -*- coding: utf-8 -*-
from setuphelpers import *
import json


def update_package():
    print("Downloading/Updating package content from upstream binary sources")

    # Initializing variables
    proxies = get_proxies()
    bin_name_string = "pdfsam-%s.msi"
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    url_api = "https://api.github.com/repos/torakiki/pdfsam/releases/latest"

    # Getting latest informations from Github API
    json_load = json.loads(wgets(url_api, proxies=proxies))
    for download in json_load["assets"]:
        if download["browser_download_url"].endswith(".msi"):
            url_dl = download["browser_download_url"]
            break

    version = json_load["tag_name"].replace("v", "")
    latest_bin = bin_name_string % version

    print("Latest %s version is: %s" % (app_name, version))
    print("Download url is: %s" % url_dl)

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: " + latest_bin)
        wget(url_dl, latest_bin, proxies=proxies)

        # Changing version of the package
        control.version = "%s-%s" % (version, int(control.version.split("-")[-1]) + 1)
        control.save_control_to_wapt()
        print("Changing package version to: %s in WAPT\\control" % control.version)

    # Deleting outdated binaries
    remove_outdated_binaries(version)
