# -*- coding: utf-8 -*-
from setuphelpers import *

# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls
app_name = "PDFsam Basic"


def install():
    # Declaring local variables
    bin_name = glob.glob("*pdfsam*.dmg")[0]

    def mount_dmg(dmg_path):
        """Mounts a dmg file.

        Returns: The path to the mount point.
        """
        try:
            return run("yes | hdiutil mount '" + dmg_path + "'").split("\t")[-1].rstrip()
        except subprocess.CalledProcessError as e:
            raise Exception("Error in mount_dmg : {0}".format(e.output))

    def install_dmg(dmg_path, key="", min_version="", get_version=None, force=False, killbefore=None, uninstallkeylist=None):
        """Installs a .dmg if it isn't already installed on the system.

        Arguments:
            dmg_path : the path to the dmg file

        Returns:
            True if it succeeded, False otherwise
        """
        ret_val = True

        dmg_name = os.path.basename(dmg_path)
        dmg_mount_path = mount_dmg(dmg_path)

        try:
            dmg_file_assoc = {".pkg": install_pkg, ".mpkg": install_pkg, ".app": install_app}
            files = [dmg_mount_path + "/" + fname for fname in os.listdir(dmg_mount_path)]
            nb_files_handled = 0
            for file in files:
                fname, fextension = os.path.splitext(file)
                if fextension in dmg_file_assoc:
                    dmg_file_assoc[fextension](
                        file,
                        key=key,
                        min_version=min_version,
                        get_version=get_version,
                        force=force,
                        uninstallkeylist=uninstallkeylist,
                        killbefore=killbefore,
                    )
                    nb_files_handled += 1

            if nb_files_handled == 0:
                error("Error : the dmg provided did not contain a package or an application, or none could be found.")

            unmount_dmg(dmg_mount_path)
        except Exception as e:
            unmount_dmg(dmg_mount_path)
            raise

    # Installing the software
    print("Installing: %s" % bin_name)
    install_dmg(bin_name)


def uninstall():
    # Uninstalling the software
    uninstall_app(app_name)
