# -*- coding: utf-8 -*-
from setuphelpers import *


def update_package():
    app_name = control.name
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    html_source = wgets("https://tools.pdf24.org/fr/creator", proxies=proxies).splitlines()
    for line in html_source:
        if "softwareVersion" in line:
            version = line.split('"')[-2]
            break
    download_url = f"https://download2.pdf24.org/pdf24-creator-{version}-x64.msi"
    latest_bin = f"pdf24-creator-{version}-x64.msi"
    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies, connect_timeout=30)
    else:
        print(f"Binary is present: {latest_bin}")

    # Checking version from file
    version_from_file = get_version_from_binary(latest_bin)
    # if not version_from_file.startswith(version) and version_from_file != '':
    if Version(version_from_file) != Version(version) and version_from_file != "":
        print(f"Changing version to the version number of the binary (from: {version} to: {version_from_file}")
        os.rename(latest_bin, latest_bin.replace(version, version_from_file))
        version = version_from_file
    else:
        print("Binary file version corresponds to online version")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(version)

    # Validating or not update-package-sources
    return package_updated
