# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *

def install():
    # Declaring variables
    bin_name = glob.glob("Parsec*.exe")[0]

    # Uninstalling previous versions
    for to_uninstall in installed_softwares("Parsec"):
        print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
        killalltasks(control.impacted_process.split(","))
        run(uninstall_cmd(to_uninstall["key"]))
        wait_uninstallkey_absent(to_uninstall["key"])

    # Installing the software
    install_exe_if_needed(
        bin_name,
        silentflags="/S /allusers",
        min_version=control.get_software_version(),
    )

def uninstall():
    dir_x64 = makepath(programfiles, "Parsec")
    dir_x86 = makepath(programfiles32, "Parsec")
    
    for to_uninstall in installed_softwares("Parsec"):
        print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
        killalltasks(control.impacted_process.split(","))
        run(uninstall_cmd(to_uninstall["key"]))
        wait_uninstallkey_absent(to_uninstall["key"])
    
    if isdir(dir_x64):
        remove_tree(dir_x64)
    
    if isdir(dir_x86):
        remove_tree(dir_x86)