# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *

def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    api_url = "https://api.github.com/repos/Scille/parsec-cloud/releases/latest"
    download_dict = {
        "windows-x64": "x86_64.exe",
        "windows-x86": "x86_64.exe",
        "linux": ".AppImage",
        "macos-x64": "x86_64.dmg",
        "macos-arm": "arm64.dmg",
    }

    # Getting latest version information from official sources
    print(f"API used is: {api_url}")
    json_load = wgets(api_url, proxies=proxies, as_json=True)
    version = json_load["tag_name"].replace("v", "")
    for to_download in json_load["assets"]:
        if download_dict[control.target_os + "-" + ensure_list(control.architecture)[0]] in to_download["name"]:
            download_url = to_download["browser_download_url"]
            latest_bin = to_download["name"]
            break

    # Downloading latest binaries
    print(f"Latest {control.name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Deleting outdated binaries
    remove_outdated_binaries(latest_bin)

    # Changing version of the package
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating update-package-sources
    return package_updated