def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    api_url = "https://api.github.com/repos/jgm/pandoc/releases/latest"
    update_dict = {
        "bin_contains": {
            "windows-x64": "windows-x86_64.msi",
            "debian_based-x64": "amd64.deb",
            "debian_based-arm64" :"arm64.deb",
            "darwin-arm64": "arm64-macOS.pkg",
            "darwin-x64": "x86_64-macOS.pkg"
        },
    }

# Getting latest version information from official sources
    print("API used is: %s" % api_url)
    json_load = wgets(api_url, proxies=proxies, as_json=True)
    version = json_load["tag_name"].replace("v", "").replace(".windows", "")
    for to_download in json_load["assets"]:
        if update_dict["bin_contains"][control.target_os + "-" + ensure_list(control.architecture)[0]] in to_download["name"]:
            download_url = to_download["browser_download_url"]
            latest_bin = to_download["name"]
            #version = to_download["name"].split('-')[1]
            break

    # Deleting binaries
    for f in glob.glob("*.pkg"):
        if f != latest_bin:
            remove_file(f)

    # Downloading latest binaries
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)
        
    control.set_software_version(version)
    control.save_control_to_wapt()

