
# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import glob
import re



def update_package():
    # Declaring local variables
    package_updated = False
    
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()

  
    # URL de base pour Pale Moon
    data = requests.head('https://www.palemoon.org/download.php?mirror=us&bits=32&type=installer',allow_redirects=True,proxies=proxies)
    download_url = data.url  
    latest_bin = download_url.split("/")[-1]
    # Utilisez une expression régulière pour extraire la version
    match = re.search(r'(\d+\.\d+\.\d+)', latest_bin)
    if match:
        version = match.group(0)
    else:
        version = ''

    print(version)    
            
            

  
    # Downloading latest binaries
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
        package_updated = True
    else:
        print("Binary is present: %s" % latest_bin)


    # Deleting outdated binaries
    for f in glob.glob('*.exe'):
        if f != latest_bin:
            remove_file(f)

           
    
    # Mettre à jour le package
    control.set_software_version(version)
    control.save_control_to_wapt()    
        

