# -*- coding: utf-8 -*-
from setuphelpers import *

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()
{
   "key":"Pale Moon 33.3.0 (x64 en-US)",
   "name":"Pale Moon 33.3.0 (x64 en-US)",
   "version":"33.3.0",
   "install_date":"",
   "install_location":"C:\\Program Files\\Pale Moon",
   "uninstall_string":"\"C:\\Program Files\\Pale Moon\\uninstall\\helper.exe\"",
   "publisher":"Moonchild Productions",
   "system_component":0,
   "win64":true
  }

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls


def install():
    # Declaring local variables
    bin_name = glob.glob('palemoon-*.exe')[0]
    # Récupérer la version depuis l'objet control
    version = control.get_software_version()

    # Construire dynamiquement la clé de registre avec la version récupérée
    key = f'Pale Moon {version} (x64 en-US)'
    # Installing the software
    
    install_exe_if_needed(bin_name,
        silentflags='/VERYSILENT /SUPPRESSMSGBOXES /NORESTART /SP-',
        key=key,
        min_version=control.get_software_version(),
    )



