# -*- coding: utf-8 -*-
##################################################
# This file is part of WAPT Enterprise
# All right reserved, (c) Tranquil IT Systems 2024
# For more information please refer to
# https://wapt.tranquil.it/store/licences.html
##################################################
from setuphelpers import *
from setupdevhelpers import *

def wait_process_finish(process_name, timeout=120):
    current_time = 0
    while find_processes(process_name):
        current_time += 1
        if current_time > timeout:
            return
        time.sleep(1)

def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()
    app_name = control.name

    sdk_dir = "winsdk"
    sdk_installers_dir = makepath(sdk_dir, "Installers")

    url = "https://developer.microsoft.com/en-us/windows/downloads/windows-sdk"

    for link in bs_find_all(url, "a", "href"):
        if "Installer" in link.text:
            download_url = link["href"]
            break

    download_url = requests.head(download_url).headers['Location']
    latest_bin = download_url.rsplit('/', 1)[-1]
    latest_bin_extension = latest_bin.rsplit('.', 1)[-1]

    wget(download_url, latest_bin)
    version = get_version_from_binary(latest_bin)

    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    remove_tree(sdk_dir, ignore_errors=True)

    run(f'{latest_bin} /features OptionId.MSIInstallTools /quiet /norestart /layout {sdk_dir}')
    wait_process_finish("winsdksetup.exe")

    # Remove useless dotNetFx installer(s) to reduce package size
    for dotnet_bin in glob.glob(f'{sdk_installers_dir}\dotNetFx*'):
            remove_file(dotnet_bin)

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated