# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import waptlicences

def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()

    download_url = "https://openvpn.net/downloads/openvpn-connect-v3-macos.dmg"
    latest_bin = requests.head(download_url).headers["Location"].rsplit("/")[-1]
    latest_bin_extension = latest_bin.rsplit('.', 1)[-1]
    version = latest_bin.split("-")[-1].split("_")[0]    

    # Downloading latest binaries
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    dmg_mount_path = mount_dmg(glob.glob('openvpn-*.dmg')[0])

    try:
        pkg_file = glob.glob(f"{dmg_mount_path}/*x86_64*.pkg")[0]
        filecopyto(pkg_file,basedir)
        unmount_dmg(dmg_mount_path)
        remove_file(latest_bin)
        
    except Exception:
        unmount_dmg(dmg_mount_path)
        raise

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated