# -*- coding: utf-8 -*-
from setupdevhelpers import *
import os
import shutil
import glob

def update_package():

    openssl_version = '3.5.4'

    wget(rf'http://srvtemplates.ad.tranquil.it/binary_cache/openssl-{openssl_version}.tar.gz',rf'openssl-{openssl_version}.tar.gz')
    unzip_with_7zip(rf'openssl-{openssl_version}.tar.gz',rf'openssl-{openssl_version}-tar')
    remove_file(rf'openssl-{openssl_version}.tar.gz')



    if not isfile(r'C:\Program Files\NASM\nasm.exe'):
        error(r'C:\Program Files\NASM\nasm.exe not found')

    add_to_system_path(r'C:\Program Files\NASM')




    if os.path.exists(f'openssl-{openssl_version}'):
        remove_tree(f'openssl-{openssl_version}')
    mkdirs('x86_x32')
    unzip_with_7zip(rf'openssl-{openssl_version}-tar\openssl-{openssl_version}.tar','.')
    with open(rf'openssl-{openssl_version}\Configurations\60-custom.conf','w') as f:
       f.write(data_custom)

    run(rf'cd openssl-{openssl_version} & set path=C:\Program Files\NASM;%path% &"C:\Program Files (x86)\Microsoft Visual Studio\2019\BuildTools\VC\Auxiliary\Build\vcvars32.bat" &"C:\Strawberry\perl\bin\perl.exe" configure VC-WIN32-rtt & nmake',timeout=7200)

    for file_to_copy in ('libcrypto_static.lib', 'libcrypto-3.dll', 'libcrypto-3.pdb',
                   'libssl_static.lib', 'libssl-3.dll', 'libssl-3.pdb' ):
        filecopyto(rf'openssl-{openssl_version}\{file_to_copy}','x86_x32')
    filecopyto(rf'openssl-{openssl_version}\apps\openssl.exe','x86_x32')

    if os.path.exists(f'openssl-{openssl_version}'):
        remove_tree(f'openssl-{openssl_version}')
    mkdirs('x86_x64')
    unzip_with_7zip(rf'openssl-{openssl_version}-tar\openssl-{openssl_version}.tar','.')
    with open(rf'openssl-{openssl_version}\Configurations\60-custom.conf','w') as f:
       f.write(data_custom)

    run(rf'cd openssl-{openssl_version} & set path=C:\Program Files\NASM;%path% &"C:\Program Files (x86)\Microsoft Visual Studio\2019\BuildTools\VC\Auxiliary\Build\vcvars64.bat" &"C:\Strawberry\perl\bin\perl.exe" configure VC-WIN64A-rtt & nmake',timeout=7200)

    for file_to_copy in ('libcrypto_static.lib', 'libcrypto-3-x64.dll', 'libcrypto-3-x64.pdb',
                   'libssl_static.lib', 'libssl-3-x64.dll', 'libssl-3-x64.pdb' ):
        filecopyto(rf'openssl-{openssl_version}\{file_to_copy}','x86_x64')
    filecopyto(rf'openssl-{openssl_version}\apps\openssl.exe','x86_x64')



    remove_tree(rf'openssl-{openssl_version}-tar')
    remove_tree(rf'openssl-{openssl_version}')


    commit_count = params.get("commit_count",0)
    control.version = "%s-%s" % (openssl_version, commit_count)
    control.save_control_to_wapt()



data_custom = r"""## -*- mode: perl; -*-
## Personal configuration targets

my %targets = (
    "VC-WIN32-rtt" => {
        inherit_from     => [ "VC-WIN32" ],
        cflags           => sub{my $v=pop; $v=~ s/\/MD/\/MT/ig; return $v},
        lflags           => "/nologo /release",
    },
    "VC-WIN64A-rtt" => {
        inherit_from     => [ "VC-WIN64A" ],
        cflags           => sub{my $v=pop; $v=~ s/\/MD/\/MT/ig; return $v},
        lflags           => "/nologo /release",
    },
);"""