# -*- coding: utf-8 -*-
from setuphelpers import *

app_name = "OpenRSAT"
bin_name = f"{app_name}.exe"
app_dir = makepath(programfiles32, app_name)
app_path = makepath(app_dir, bin_name)


def install():
    # Installing software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir) and force:
        remove_tree(app_dir)
    mkdirs(app_dir)
    filecopyto(bin_name, app_path)

    # Creating shortcuts
    create_desktop_shortcut(app_name, target=app_path)
    create_programs_menu_shortcut(app_name, target=app_path)


def uninstall():
    # Uninstalling software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir):
        remove_tree(app_dir)

    # Removing shortcuts
    remove_desktop_shortcut(app_name)
    remove_programs_menu_shortcut(app_name)
