# -*- coding: utf-8 -*-
from setuphelpers import *
import json

build_folder = r'c:\build'
git = r'"C:\Program Files\Git\bin\git.exe"'
lazbuild = r'C:\lazarus_4_0\lazarus\lazbuild.exe'
package_version=1

def update_package():
    # Remove old build folder
    if isdir(build_folder):
        print(f"Old build folder exists ({build_folder}). Remove it.")
        remove_tree(build_folder)
    
    # Clone OpenRSAT repository
    print("Clone OpenRSAT repository.")
    run(fr'{git} clone https://github.com/tranquilit/OpenRSAT.git {build_folder}')

    # Retrieve last tag
    print("Retrieve last tag.")
    tag = run(fr'{git} -C {build_folder} describe --tags --abbrev=0')
    tag = tag.strip()

    # Checkout to last tag
    print(f"Last tag found ({tag}). Checkout to this tag.")
    run(fr'{git} -C {build_folder} checkout {tag}')

    # Update submodules
    print("Update submodules")
    run(fr'{git} -C {build_folder} submodule update --progress --init -- "submodules/mORMot2"')
    run(fr'{git} -C {build_folder} submodule update --progress --init -- "submodules/pltis_uicomponents"')
    run(fr'{git} -C {build_folder} submodule update --progress --init -- "submodules/pltis_utils"')
    run(fr'{git} -C {build_folder} submodule update --progress --init -- "submodules/pltis_virtualtrees"')
    run(fr'{git} -C {build_folder} submodule update --progress --init -- "submodules/metadarkstyle"')

    # Patch pltis_uicomponents
    print("Patch pltis_uicomponents")
    f = open(fr'{build_folder}\submodules\pltis_uicomponents\src\standard\tis.ui.lvlgraphcontrol.pas','r')
    filedata = f.read()
    f.close()
    newdata = filedata.replace("Laz_AVL_Tree","AVL_Tree")
    f = open(fr'{build_folder}\submodules\pltis_uicomponents\src\standard\tis.ui.lvlgraphcontrol.pas','w')
    f.write(newdata)
    f.close()

    # Download mORMot2 static requirements
    print("Download mORMot2 static")
    wget('https://synopse.info/files/mormot2static.7z','mormot2static.7z')
    run(r'"c:\Program Files\7-Zip\7z.exe" x -y mormot2static.7z -ostatic')
    remove_tree(fr'{build_folder}\submodules\mORMot2\static')
    os.rename('static', fr'{build_folder}\submodules\mORMot2\static')
    remove_file('mormot2static.7z')

    # Add required package to Lazarus IDE
    print("Add required package to Lazarus IDE")
    run(fr'{lazbuild} --add-package-link {build_folder}\submodules\mORMot2\packages\lazarus\mormot2.lpk')
    run(fr'{lazbuild} --add-package-link {build_folder}\submodules\pltis_uicomponents\pack\pltis_uicomponents.lpk')
    run(fr'{lazbuild} --add-package-link {build_folder}\submodules\pltis_utils\pltis_utils.lpk')
    run(fr'{lazbuild} --add-package {build_folder}\submodules\pltis_virtualtrees\virtualtreeview_package.lpk')
    run(fr'{lazbuild} --add-package {build_folder}\submodules\metadarkstyle\metadarkstyle.lpk')
    run(fr'{lazbuild} --add-package {build_folder}\submodules\metadarkstyle\metadarkstyledsgn.lpk')
    run(fr'{lazbuild} --add-package-link {build_folder}\packages\OpenRSATCore\OpenRSATCore.lpk')

    # Build Lazarus project
    print("Build lazarus project")
    run(fr'{lazbuild} --build-mode=win32 {build_folder}\sources\OpenRSAT.lpi')

    # WAPT Package prepare
    filecopyto(fr'{build_folder}\bin\win32\OpenRSAT.exe','OpenRSAT.exe')

    # Update Package version
    print("Update package version")
    version = f"{tag[1:]}.{package_version}"
    control.set_software_version(version)
    control.save_control_to_wapt()
