# -*- coding: utf-8 -*-
from setuphelpers import *
import json


def update_package():
    # Declaring local variables
    result = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    api_url = "https://sourceforge.net/projects/openofficeorg.mirror/best_release.json"
    bin_contains = "Apache_OpenOffice_"

    # Getting latest version information from official sources
    print("API used is: %s" % api_url)
    json_load = json.loads(wgets(api_url, proxies=proxies))
    for download in json_load["platform_releases"]:
        latest_bin = json_load["platform_releases"][download]["filename"].split("/")[-1]
        if bin_contains in latest_bin and "_Win_x86_install_" in latest_bin:
            download_url = json_load["platform_releases"][download]["url"]
            version = json_load["platform_releases"][download]["filename"].split("/")[1]
            break

    if not "en" in control.locale:
        download_url = download_url.replace("en-US", control.locale)
        latest_bin = latest_bin.replace("en-US", control.locale)

    print("Latest %s version is: %s" % (app_name, version))
    print("Download url is: %s" % download_url)

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        result = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.version = "%s-%s" % (Version(version), control.version.split("-", 1)[-1])
    # control.set_software_version(version)
    control.save_control_to_wapt()

    # Unzipping .msi contained in the .exe file
    print("Unzipping .msi contained in the .exe file")
    unzip_with_7zip(latest_bin, target=".", filenames=["openoffice*"])

    # Deleting useless binaries
    remove_file(latest_bin)

    # Validating update-package-sources
    return result
