# -*- coding: utf-8 -*-
from setuphelpers import *
import json
try:
    from setuphelpers_windows import get_file_association
    get_file_assocation = get_file_association
except ImportError:
    pass


r"""
https://wiki.documentfoundation.org/Deployment_and_Migration

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls
app_name = "OpenOffice"
# silent_args_dict = {"SETUP_USED": 1, "ADDLOCAL": "ALL", "CREATEDESKTOPLINK": 0, "RebootYesNo": "No", "REMOVE": "gm_o_Onlineupdate"}
silent_args_dict = {
    "SETUP_USED": 1,
    "ALLUSERS": 1,
    "CREATEDESKTOPLINK": 0,
    "REBOOTYESNO": "No",
    "ISCHECKFORPRODUCTUPDATES": 0,
    "VC_REDIST": 0,
    "QUICKSTART": 0,
    "ADDLOCAL": "ALL",
    "REMOVE": "gm_o_Onlineupdate",
}
force_register_as_default_mso_app = False  # Make sure that AOO will BE the default application for any Office applications
force_no_register_as_default_mso_app = False  # Make sure that AOO will NOT BE the default application for any Office applications


def install():
    # Initializing variables
    package_version = control.get_software_version()
    bin_name = glob.glob("*.msi")[0]

    # Uninstalling LibreOffice if detected
    for uninstall in installed_softwares(name="LibreOffice"):
        if uninstall_key_exists(uninstall["key"]):
            print("Removing: %s" % (uninstall["name"]))
            run(uninstall_cmd(uninstall["key"]))

    # Uninstalling OpenOffice if too old and previously exe install
    for uninstall in installed_softwares(name=app_name):
        # if Version(uninstall["version"]) < Version(package_version):
        if Version(uninstall["version"]) < Version(get_version_from_binary(bin_name)) or Version(uninstall["version"]) == Version("4.111.9808"):
            if uninstall_key_exists(uninstall["key"]):
                print("Removing: %s" % (uninstall["name"]))
                run(uninstall_cmd(uninstall["key"]))

    # Defining Office default applications
    """
    REGISTER_ALL_MSO_TYPES (default=0) - use OpenOffice as the default application for Microsoft Office file formats 
    REGISTER_NO_MSO_TYPES  (default=0) - don't use OpenOffice as default application for any Microsoft Office file formats 
    REGISTER_DOC           (default=0) - use OpenOffice as the default application for Microsoft Word file format .doc (You can use similar for .xls, .ppt etc.)
    """
    if not force_register_as_default_mso_app or not force_no_register_as_default_mso_app:
        # Checking if MSO file extensions refer to MSO apps and affect AOO if not
        if get_file_assocation(".doc") is not None and get_file_assocation(".docx") is not None:
            if not get_file_assocation(".doc").startswith("Word") and not get_file_assocation(".docx").startswith("Word"):
                silent_args_dict["REGISTER_DOC"] = 1
                silent_args_dict["REGISTER_DOCX"] = 1
        else:
            silent_args_dict["REGISTER_DOC"] = 1
            silent_args_dict["REGISTER_DOCX"] = 1
        if not get_file_assocation(".xls") is not None and get_file_assocation(".xlsx") is not None:
            if not get_file_assocation(".xls").startswith("Excel") and not get_file_assocation(".xlsx").startswith("Excel"):
                silent_args_dict["REGISTER_XLS"] = 1
                silent_args_dict["REGISTER_XLSX"] = 1
        else:
            silent_args_dict["REGISTER_XLS"] = 1
            silent_args_dict["REGISTER_XLSX"] = 1
        if get_file_assocation(".ppt") is not None and get_file_assocation(".pptx") is not None:
            if not get_file_assocation(".ppt").startswith("PowerPoint") and not get_file_assocation(".pptx").startswith("PowerPoint"):
                silent_args_dict["REGISTER_PPT"] = 1
                silent_args_dict["REGISTER_PPTX"] = 1
        else:
            silent_args_dict["REGISTER_PPT"] = 1
            silent_args_dict["REGISTER_PPTX"] = 1
        if get_file_assocation(".pub") is not None:
            if get_file_assocation(".pub").startswith("Publisher"):
                silent_args_dict["REGISTER_PUB"] = 1
        else:
            silent_args_dict["REGISTER_PUB"] = 1

    if not force_register_as_default_mso_app or not force_no_register_as_default_mso_app:
        # Checking if a version of MSO is installed
        count_mso_apps = 0
        if installed_softwares(name="Microsoft Office "):
            count_mso_apps += 1
        if installed_softwares(name="Office 365"):
            count_mso_apps += 1
        if installed_softwares(name="Microsoft 365"):
            count_mso_apps += 1

    if force_register_as_default_mso_app:
        # Register AOO as default MSO apps
        silent_args_dict["REGISTER_ALL_MSO_TYPES"] = 1
    elif force_no_register_as_default_mso_app:
        # Do not register AOO as default MSO apps
        silent_args_dict["REGISTER_NO_MSO_TYPES"] = 1
    else:
        if count_mso_apps == 0:
            # Register AOO as default MSO apps if no MSO version was detected
            silent_args_dict["REGISTER_ALL_MSO_TYPES"] = 1

    # Installing the package
    print("Installing: %s" % app_name)
    # run(r'msiexec /a "%s" /lp! "c:\temp\%s.log" TARGETDIR="c:\temp\%s" /q' % (bin_name, app_name, app_name))
    install_msi_if_needed(bin_name, properties=silent_args_dict, timeout=600)
