# -*- coding: utf-8 -*-
from setuphelpers import *


def install():
    bin_name = glob.glob("OpenBoard_Installer_*.exe")[0]
    install_exe_if_needed(
        bin_name,
        silentflags="/VERYSILENT /SUPPRESSMSGBOXES /NORESTART",
        key="{8CCA6AC7-BBF9-4DD2-8E70-A907E0FCA38F}}_is1",
        min_version=control.get_software_version(),
    )


def session_setup():
    # "C:\Users\username\AppData\Local\OpenBoard\OpenBoardUser.config"
    user_conf_dir = makepath(user_local_appdata, "OpenBoard")
    user_conf_path = makepath(user_conf_dir, "OpenBoardUser.config")
    if not isdir(user_conf_dir):
        mkdirs(user_conf_dir)
    if isfile(user_conf_dir):
        if inifile_readstring(user_conf_path, "App", "EnableAutomaticSoftwareUpdates").lower() != "false":
            print("Disabling: automatic updates")
            killalltasks(control.get_impacted_process_list())
            inifile_writestring(user_conf_path, "App", "EnableAutomaticSoftwareUpdates", "false")
    else:
        print("Disabling: automatic update check")
        killalltasks(control.get_impacted_process_list())
        inifile_writestring(user_conf_path, "App", "EnableAutomaticSoftwareUpdates", "false")
