from setuphelpers import *
import re


def update_package():
    # Initialisation des variables
    proxies = get_proxies() or get_proxies_from_wapt_console()
    app_name = control.name
    target_os = control.target_os
    base_url = "https://cdn.kde.org/ci-builds/graphics/okular/"
    package_updated = False

    # Récupération et tri des versions depuis l'index
    index = wgets(base_url, proxies=proxies)
    versions = sorted(re.findall(r'<a href="([^"/]+/)">', index), key=lambda p: Version(p.strip('/')), reverse=True)
    
    # Construction de l'URL pour la dernière version
    latest_version_folder = versions[0].strip('/')
    version = latest_version_folder.split('-')[-1]
    latest_folder_url = f"{base_url}{latest_version_folder}/"

    # Récupération du dossier cible pour le système d'exploitation
    folder_index = wgets(latest_folder_url, proxies=proxies)
    os_folders = re.findall(r'<a href="([^"/]+/)">', folder_index)
    target_os_folder = next((folder for folder in os_folders if target_os in folder), None)
    

    # Construction de l'URL et recherche du fichier .exe
    target_os_url = f"{latest_folder_url}{target_os_folder}"
    os_folder_index = wgets(target_os_url, proxies=proxies)
    exe_files = re.findall(r'<a href="([^"/]+\.exe)">', os_folder_index)
    

    # Téléchargement du dernier fichier .exe et mise à jour du package
    latest_bin = exe_files[0]
    download_url = f"{target_os_url}{latest_bin}"
                
    # Suppression des anciens fichiers .exe et téléchargement du nouveau
    for f in glob.glob("*.exe"):
        if f != latest_bin:
            remove_file(f)
    wget(download_url, latest_bin, proxies=proxies)

    # Mise à jour de la version dans le fichier de contrôle
    control.set_software_version(version)
    control.save_control_to_wapt()
    package_updated = True

    return package_updated
