# -*- coding: utf-8 -*-
from setuphelpers import *

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()
{
   "key":"Okular",
   "name":"Okular",
   "version":"24.05.0",
   "install_date":"",
   "install_location":"",
   "uninstall_string":"\"C:\\Program Files\\Okular\\uninstall.exe\"",
   "publisher":"KDE e.V.",
   "system_component":0,
   "win64":false
  }

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls
app_dir = makepath(programfiles, "Okular")


def install():
    # Declaring local variables
    bin_name = glob.glob("okular-release_*-x86_64.exe")[0]
    # Installing the software
    # Adding the package to the "list-registry"
    register_windows_uninstall(control)  # control is a PackageEntry object corresponding to the package

    install_exe_if_needed(bin_name, silentflags="/S", key="Okular", min_version=control.get_software_version(),
    )
    uninstallkey.clear()


def uninstall():
    # uninstalling the package
    print("Uninstalling")
    if isdir(app_dir):
        remove_tree(app_dir)
    unregister_uninstall("Okular")

    for to_uninstall in installed_softwares("Okular"):
        print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
        killalltasks(ensure_list(control.impacted_process))
        run(uninstall_cmd(to_uninstall["key"])[:2], accept_returncodes=[0, 1, 3010])
        wait_uninstallkey_absent(to_uninstall["key"])
