from setuphelpers import *
import re
import requests

def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = "okular"
    target_os = "macos-x86_64"  # Changer le nom de l'OS cible si nécessaire

    # last version from official sources
    url = "https://cdn.kde.org/ci-builds/graphics/okular/"
    index = wgets(url, proxies=proxies)

    # Regular expression to find versions
    re_versions = re.compile(r'<a href="([^"/]+/)">')

    # find and sort the latest versions
    versions = sorted(re_versions.findall(index), key=lambda p: Version(p.strip('/')), reverse=True)
    
    # check three last versions
    for version in versions[:3]:
        latest_folder_version = version.strip('/')
        version_number = latest_folder_version.split('-')[-1]

        # repository find
        latest_folder_url = url + latest_folder_version + "/"
        folder_index = wgets(latest_folder_url, proxies=proxies)
        
        # Regular expression to find repository
        re_folders = re.compile(r'<a href="([^"/]+/)">')
        folders = re_folders.findall(folder_index)

        # find repository for os_target
        target_os_folder = None
        for folder in folders:
            if target_os in folder:
                target_os_folder = folder
                break

        if target_os_folder:
            # Build URL
            target_os_url = latest_folder_url + target_os_folder
            os_folder_index = wgets(target_os_url, proxies=proxies)
            
            # Regular expression to find ".dmg" file
            re_files = re.compile(r'<a href="([^"/]+\.dmg)">')
            files = re_files.findall(os_folder_index)

            if files:
                # take first ".dmg"
                dmg_file = files[0]
                download_url = target_os_url + dmg_file
                latest_bin = download_url.split("/")[-1]
                version = latest_bin.split("_")[1].split("-")[0]       
    
                # Remove files
                for f in glob.glob("*.dmg"):
                    if f != latest_bin:
                        remove_file(f)

                # Downloading latest binaries
                print(latest_bin)
                wget(download_url, latest_bin, proxies=proxies)
                package_updated = True
                break

    control.set_software_version(version)
    control.save_control_to_wapt()



    if not package_updated:
        print("No suitable version found for macOS.")

