# -*- coding: utf-8 -*-
from setuphelpers import *
import json


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()
        
    api_url = "https://api.github.com/repos/obsproject/obs-studio/releases/latest"

    # Getting latest version information from official sources
    print("API used is: %s" % api_url)
    json_load = json.loads(wgets(api_url, proxies=proxies))
    for to_download in json_load["assets"]:
        if to_download["name"].endswith('.exe'):
            download_url = to_download["browser_download_url"]
            version = json_load["tag_name"].split("-")[-1].replace("v", "")
            latest_bin = to_download["name"]
            break

    # Downloading latest binaries
    print("Latest %s version is: %s" % (control.name, version))
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
        package_updated = True
    else:
        print("Binary is present: %s" % latest_bin)

    # Checking version from file
    version = get_version_from_binary(latest_bin)

    control.set_software_version(version)
    control.save_control_to_wapt()

    for f in glob.glob('*.exe'):
        if f != latest_bin:
            remove_file(f)

    # Validating update-package-sources
    return package_updated
