# -*- coding: utf-8 -*-
from setuphelpers import *

impacted_third_party_processes = [
    "msedge",
    "msedgewebview2",
    "Rocket.Chat",
    "Teams",
    "msteams",
    "LogiTune",
    "NVIDIA Broadcast",
]


def install():
    bin_name = glob.glob("OBS-Studio-*.exe")[0]
    try:
        install_exe_if_needed(
            bin_name,
            silentflags="/S",
            key="OBS Studio",
            min_version=control.get_software_version(),
            killbefore=impacted_third_party_processes if force else [],
        )
    except Exception as e:
        if e.returncode == 6:
            for p in impacted_third_party_processes:
                if isrunning(p):
                    print(f"{p} is running")
            error(
                'Installation failed with "exit status 6"\nIt means that there is a program running that may be using OBS Virtual Camera\nYou can force install this package if you want to try killing them before'
            )


def uninstall():
    remove_programs_menu_folder("OBS Studio")
