# -*- coding: utf-8 -*-
from setuphelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()
        
    api_url = "https://api.github.com/repos/obsproject/obs-studio/releases/latest"

    download_os_dict = {
        'darwin-x64': '-macOS-Intel.dmg',
        'darwin-arm': '-macOS-Apple.dmg',
    }
    os_type = control.target_os + "-" + ensure_list(control.architecture)[0]

    # Getting latest version information from official sources
    print("API used is: %s" % api_url)
    json_load = wgets(api_url, proxies=proxies, as_json=True)
    for to_download in json_load["assets"]:
        if to_download["name"].endswith(download_os_dict[os_type]):
            download_url = to_download["browser_download_url"]
            version = json_load["tag_name"].split("-")[-1].replace("v", "")
            latest_bin = to_download["name"]
            latest_bin_extension = latest_bin.rsplit('.', 1)[-1]
            break

    # Downloading latest binaries
    print("Latest %s version is: %s" % (control.name, version))
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
        package_updated = True
    else:
        print("Binary is present: %s" % latest_bin)

    control.set_software_version(version)
    control.save_control_to_wapt()

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    # Validating update-package-sources
    return package_updated
