# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import waptlicences

def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()
    app_name = control.name

    base_url = "https://www.nvidia.com/fr-fr/software/nvidia-app/"

    download_url = ""
    for a in bs_find_all(base_url, 'a','class', 'btn-content btncta'):
        if a['href'].endswith('.exe'):
            download_url = a['href']

    latest_bin = download_url.split('/')[-1]
    version = latest_bin.split('_')[-1]
    version = version.replace('.exe', '')[1:]

    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Deleting outdated binaries
    for f in glob.glob('*.exe'):
        if f != latest_bin:
            remove_file(f)

    expected_issuer = 'NVIDIA Corporation'
    sign_name = waptlicences.check_exe_signing_certificate(latest_bin)[0]
    if sign_name != expected_issuer:
        error(f'Bad issuer {sign_name} != {expected_issuer} ')

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {version})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({version})")

    control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating update-package-sources
    return package_updated