# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *


def host_as_nvidia_gpu():
    wmi = wmi_info(keys=['Win32_VideoController'])
    gpu = wmi['Win32_VideoController']

    if isinstance(gpu, dict):
        if 'NVIDIA' in gpu['Name']:
            return True

    if isinstance(gpu, list):
        for v in gpu:
            if 'NVIDIA' in v['Name']:
                return True
            
    return False

def install():
    # Declaring local variables
    bin_name = glob.glob("NVIDIA_app*.exe")[0]

    if not host_as_nvidia_gpu():
        error("The current computer doesn't have a nvidia GPU !")

    install_exe_if_needed(
        bin_name,
        silentflags="-s -noreboot -noeula",
        key="{B2FE1952-0186-46C3-BAEC-A80AA35AC5B8}_Display.NvApp",
        min_version=control.get_software_version(),
    )

def uninstall():
    quiet_uninstall_string = installed_softwares(name=f"Application NVIDIA {control.get_software_version()}")[0]["uninstall_string"] + " -silent"
    run(quiet_uninstall_string)