# -*- coding: utf-8 -*-
from setuphelpers import *


app_name = "nushell"
app_dir = makepath(systemdrive, programfiles, "nushell")
menu_shortcut = makepath(app_dir, "nu.exe")


def install():
    if not isdir(app_dir):
        zip_name = glob.glob("nu-*-x86_64-pc-windows-msvc.zip")[0]
        mkdirs("nushell")
        unzip_dest = "nushell"
        unzipped_dir = "nushell"

        # Installing software
        killalltasks(ensure_list(control.impacted_process))
        if isdir(app_dir) and force:
            remove_tree(app_dir)
        unzip(zip_name, unzip_dest)
        copytree2(unzipped_dir, app_dir, onreplace=default_overwrite)

        create_programs_menu_shortcut("nushell", menu_shortcut)


def uninstall():
    print("Désinstallation de nushell")
    killalltasks(ensure_list(control.impacted_process))
    remove_tree(app_dir)
    remove_programs_menu_shortcut("nushell")
