# -*- coding: utf-8 -*-
##################################################
# This file is part of WAPT Enterprise
# All right reserved, (c) Tranquil IT Systems 2024
# For more information please refer to
# https://wapt.tranquil.it/store/licences.html
##################################################
from setuphelpers import *
from iniparse import ConfigParser
import os


def install():
    install_apt('zlib1g zlib1g-dev')

    install_dir = makepath('/','opt',control.package.split('-',1)[1])
    appimage = glob.glob("*.AppImage")[0]
    install_appimage(appimage,install_dir)

def uninstall():
    install_dir = makepath('/','opt',control.package.split('-',1)[1])
    uninstall_appimage(install_dir)

def install_appimage(appimage,install_dir,binaliasname=None):
    run('chmod a+x ./' + appimage)

    if isdir(install_dir):
        uninstall_appimage(install_dir)

    mkdirs(install_dir)

    name_appimage = appimage.split('/')[-1]
    filecopyto(appimage, makepath(install_dir, name_appimage))
    run('"./%s" --appimage-extract' % appimage)
    

    for desktop in glob.glob(makepath('squashfs-root','*.desktop')):
 
        desktop_cp = ConfigParser()
        desktop_cp.optionxform = str
        desktop_file = open(desktop, encoding="utf-8")
        desktop_cp.readfp(desktop_file)
        bin_path = desktop_cp.get('Desktop Entry',"Exec")

        newbin_path = install_dir + '/' + name_appimage
        if ' %' in bin_path:
            newbin_path = newbin_path + ' %' + bin_path.split(' %',1)[1]

        icon_path = desktop_cp.get('Desktop Entry',"Icon")

        srcicon = makepath('squashfs-root',icon_path +'.svg')
        if not isfile(srcicon):
            srcicon = makepath('squashfs-root',icon_path +'.png')

        if not isfile(srcicon):
            lstglob = glob.glob(makepath('squashfs-root','*.svg'))
            if lstglob :
                srcicon=lstglob[0]

        if not isfile(srcicon):
            lstglob = glob.glob(makepath('squashfs-root','*.png'))
            if lstglob :
                srcicon=lstglob[0]
            else:
                srcicon = None

        if srcicon:            
            new_icon = install_dir + '/' + srcicon.split('/')[-1]
            filecopyto(srcicon,new_icon)
            desktop_cp.set('Desktop Entry',"Icon",new_icon) 

        desktop_cp.set('Desktop Entry',"Exec",newbin_path)
       
        with open(desktop, 'w', encoding="utf-8") as f:
            desktop_cp.write(f)

        pathdesk = makepath(install_dir,desktop.split('/')[-1])
        filecopyto(desktop, pathdesk)
        run('chown root:root "%s" ' % pathdesk)

    for f in glob.glob(makepath(install_dir,'*.desktop')):
        run('ln -sf "%s" "/usr/share/applications/%s"' % (f,f.split('/')[-1]))

    if binaliasname :
        run(f"ln -sf {install_dir}/{name_appimage} /usr/bin/{binaliasname}")

    remove_tree('squashfs-root')

def uninstall_appimage(install_dir):

    if not glob.glob(makepath(install_dir,'*.desktop')):
        error('.desktop not found')

    for f in glob.glob(makepath(install_dir,'*.desktop')):
        deskfile = f.split('/')[-1]
        system_desktop = makepath("/","usr","share","applications",deskfile)
        if isfile(system_desktop):
            remove_file(system_desktop)
    remove_tree(install_dir)
