# -*- coding: utf-8 -*-
from setuphelpers import *


def install():
    bin_name = glob.glob("Nextcloud-*.msi")[0]
    install_msi_if_needed(
        bin_name,
        min_version=control.get_software_version(),
        name='Nextcloud'
    )

    registry_setstring(HKEY_LOCAL_MACHINE, r"SOFTWARE\Wow6432Node\Nextcloud\Nextcloud", "skipUpdateCheck", 1, type=REG_DWORD)
    registry_setstring(HKEY_LOCAL_MACHINE, r"SOFTWARE\Wow6432Node\Nextcloud GmbH\Nextcloud", "skipUpdateCheck", 1, type=REG_DWORD)

def session_setup():
    if not isdir(makepath("C:", "Users", user, "AppData", "Roaming", "Nextcloud")):
        mkdirs(r'%Appdata%\Nextcloud')
    else:
        inifile_deleteoption(makepath(application_data, "Nextcloud", "nextcloud.cfg"),"Nextcloud","autoUpdateCheck")
        inifile_writestring(makepath(application_data, "Nextcloud", "nextcloud.cfg"),"Nextcloud","autoUpdateCheck","false")
        inifile_writestring(makepath(application_data, "Nextcloud", "nextcloud.cfg"),"General","skipUpdateCheck","true")