# -*- coding: utf-8 -*-
from setuphelpers import *
import json


##def update_package():
##    # Declaring local variables
##    package_updated = False
##    proxies = get_proxies()
##    if not proxies:
##        proxies = get_proxies_from_wapt_console()
##    api_url = "https://api.github.com/repos/nextcloud-releases/desktop/releases/latest"
##    download_dict = {
##        "windows": "x64.msi",
##        "linux": "x86_64.AppImage",
##        "darwin": ".pkg",
##    }
##
##    # Getting latest version information from official sources
##    print("API used is: %s" % api_url)
##    json_load = json.loads(wgets(api_url, proxies=proxies))
##    version = json_load["tag_name"].split("-")[-1].replace("v", "")
##    download_url = download_dict[control.target_os].replace("version", version)
##    latest_bin = download_url.split("/")[-1]
##
##    # Downloading latest binaries
##    print("Latest %s version is: %s" % (control.name, version))
##    print("Download URL is: %s" % download_url)
##
##    if not isfile(latest_bin):
##        print("Downloading: %s" % latest_bin)
##        wget(download_url, latest_bin, proxies=proxies)
##    else:
##        print("Binary is present: %s" % latest_bin)
##
##    # Checking version from file
##    version_from_file = get_version_from_binary(latest_bin)
##    print("version from file :" + version_from_file )
##    if Version(version_from_file, 4) != Version(version, 4) and version_from_file != "":
##        print("Changing version to the version number of the binary")
##        version = version_from_file
##    else:
##        print("Binary file version corresponds to online version")
##
##    # Changing version of the package
##    if Version(version, 4) > Version(control.get_software_version(), 4):
##        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
##        package_updated = True
##    else:
##        print("Software version up-to-date (%s)" % Version(version))
##    control.set_software_version(version)
##    control.save_control_to_wapt()
##
##    # Deleting outdated binaries
##    remove_outdated_binaries(version)
##
##    # Validating update-package-sources
##    return package_updated

def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()

    api_url = "https://api.github.com/repos/nextcloud-releases/desktop/releases/latest"
    download_dict = {
        "windows": "x64.msi",
        "linux": "x86_64.AppImage",
        "darwin": ".pkg",
    }
    releases_dict = wgets(api_url, proxies=proxies, as_json=True)

    for asset in releases_dict["assets"]:
        if asset["browser_download_url"].endswith(download_dict[control.target_os]):
            download_url = asset["browser_download_url"]
            latest_bin = download_url.rsplit('/')[-1]
            version = releases_dict["tag_name"][1:]
            break

    # Downloading latest binaries
    print("Latest %s version is: %s" % (control.name, version))
    print("Download URL is: %s" % download_url)

    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Checking version from file
    version_from_file = get_version_from_binary(latest_bin)
    print("version from file :" + version_from_file )
    if Version(version_from_file, 4) != Version(version, 4) and version_from_file != "":
        print("Changing version to the version number of the binary")
        version = version_from_file
    else:
        print("Binary file version corresponds to online version")

    # Changing version of the package
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()


    return package_updated