# -*- coding: utf-8 -*-
from setuphelpers import *
import json

def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()

    api_url = "https://api.github.com/repos/nextcloud-releases/talk-desktop/releases/latest"
    download_dict = {
        "windows": "x64.msi",
        "linux": "x64.zip",
        "darwin": ".dmg",
    }
    releases_dict = wgets(api_url, proxies=proxies, as_json=True)

    for asset in releases_dict["assets"]:
        if asset["browser_download_url"].endswith(download_dict[control.target_os]):
            download_url = asset["browser_download_url"]
            latest_bin = download_url.rsplit('/')[-1]
            version = releases_dict["tag_name"][1:]
            break

    # Downloading latest binaries
    print("Latest %s version is: %s" % (control.name, version))
    print("Download URL is: %s" % download_url)

    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Changing version of the package
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated