# -*- coding: utf-8 -*-
from setuphelpers import *

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls
def install():
    # Déclarer les variables locales
    bin_name = glob.glob('Netron-Setup-*.exe')[0]
          
        
    while True:
        try:
            install_exe_if_needed(
                bin_name,
                silentflags='/S /D="c:\\Program Files\\Netron"',
                min_version=control.get_software_version(),
            )
            break
        except: 
            if not params.get("install_with_luti", False):
                raise
            else:
                time.sleep(10)
    
    uninstallkey.clear()

def uninstall():
    # Chemin vers le programme de désinstallation
    uninstall_path = r'c:\Program Files\Netron\uninstall Netron.exe'
    # Répertoire d'installation
    app_dir = r'c:\\Program Files\\Netron'
    
    try:
        # Tuer toutes les tâches liées au logiciel
        killalltasks(control.impacted_process)
        
        # Désinstaller le logiciel
        if os.path.isfile(uninstall_path):
            print(f"Désinstallation de Netron : {uninstall_path}")
            run(f'"{uninstall_path}" /S')
        else:
            print("Programme de désinstallation introuvable.")
        
        # Supprimer le répertoire d'installation s'il existe    
        if os.path.isdir(app_dir):
            print(f"Suppression du répertoire : {app_dir}")
            remove_tree(app_dir)
            if not os.path.isdir(app_dir):
                print(f"Répertoire {app_dir} supprimé avec succès.")
            else:
                print(f"Échec de la suppression du répertoire {app_dir}.")
        else:
            print(f"Le répertoire {app_dir} n'existe pas.")
    except Exception as e:
        print(f"Une erreur s'est produite lors de la désinstallation : {e}")
