# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import glob
import re

def update_package():
    # Declaring local variables
    package_updated = False
    
    # https://www.tenable.com/downloads/api/v2/pages/nessus-agents
    
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()
    download_url = "https://www.tenable.com/downloads/api/v2/pages/nessus-agents/files/NessusAgent-latest-Win32.msi"

    # Effectuer la requête pour récupérer les en-têtes
    try:
        response = requests.get(download_url, proxies=proxies, allow_redirects=True)
        headers = response.headers
        
        # Extraction du nom de fichier depuis les en-têtes
        content_disposition = headers.get('content-disposition', '')
        filename_match = re.search(r'filename="(.+?)"', content_disposition)
        if filename_match:
            filename = filename_match.group(1)
            print(f"Filename: {filename}")
            
        else:
            print("Filename not found in headers.")
    
    except requests.RequestException as e:
        print(f"Error during request: {e}")
    latest_bin = filename
    version = latest_bin.split('-')[1]

    
    
    # Downloading latest binaries
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
        package_updated = True
    else:
        print("Binary is present: %s" % latest_bin)


    # Deleting outdated binaries
    for f in glob.glob('*.msi'):
        if f != latest_bin:
            remove_file(f)

         
    version = get_version_from_binary(latest_bin)
    # Mettre à jour le package
    control.set_software_version(version)
    control.save_control_to_wapt()    
        

