# -*- coding: utf-8 -*-
from setuphelpers import *
import json

# Defining variables
bin_name_sub = "Mumble-%s.dmg"


def update_package():
    # Initializing variables
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    git_repo = "mumble-voip/mumble"
    url_api = "https://api.github.com/repos/%s/releases" % git_repo
    release_found = False
    bin_end = bin_name_sub.split("%s")[-1]

    # Getting latest version from official sources
    print("API used is: %s" % url_api)
    releases = json.loads(wgets(url_api, proxies=proxies))

    for json_load in releases:
        for download in json_load["assets"]:
            if download["name"].endswith(bin_end):
                url_dl = download["browser_download_url"]
                version = json_load["tag_name"].replace("v", "")
                latest_bin = bin_name_sub % version
                release_found = True
                break
        if release_found:
            break

    print("Latest %s version is: %s" % (app_name, version))
    print("Download url is: %s" % url_dl)

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(url_dl, latest_bin, proxies=proxies)

        # Changing version of the package
        control.version = "%s-%s" % (version, control.version.split("-", 1)[-1])
        control.save_control_to_wapt()
        print("Changing package version to: %s in WAPT\\control" % control.version)

    # Deleting outdated binaries
    remove_outdated_binaries(version)
