# -*- coding: utf-8 -*-
from setuphelpers import *

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls


def install():
    # Declaring local variables
    # Uninstalling older versions of the software
    for to_uninstall in installed_softwares(name="MSBuild Structured Log Viewer Machine-Wide Installer"):
        if Version(to_uninstall["version"]) < Version(control.get_software_version()):
            print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
            killalltasks(ensure_list(control.impacted_process))
            run(uninstall_cmd(to_uninstall["key"]))
            wait_uninstallkey_absent(to_uninstall["key"])
            if isdir(to_uninstall["install_location"]):
                remove_tree(to_uninstall["install_location"])


    # Installing the software
    print("Installing: Setup.msi")
    install_msi_if_needed("Setup.msi")
