# -*- coding: utf-8 -*-
from setuphelpers import *
import time
r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls


def install():

    # Declaring local variables
    bin_name = glob.glob("Mogan*.exe")[0]
    # Installing the software
    
    # Uninstalling older version of the software that can remains
    for to_uninstall in installed_softwares("Mogan"):
      if Version(to_uninstall["version"]) < Version(control.get_software_version()):
        print(f"Removing: {to_uninstall['name']} ({to_uninstall['version']})")
        killalltasks(ensure_list(control.impacted_process))
        run(uninstall_cmd(to_uninstall["key"]))
        time.sleep(60)
        unregister_uninstall(to_uninstall['key'],win64app=to_uninstall['win64'])

    install_exe_if_needed(bin_name,
        silentflags='/S',
        key='MoganSTEM',
        min_version=control.get_software_version()
    )

def uninstall():
    for uninstall in installed_softwares("MoganSTEM"):
        run(uninstall_cmd(uninstall["key"]))

        time.sleep(60)

        if uninstall_key_exists(uninstall["key"]): 
            unregister_uninstall(uninstall["key"])
    

def audit():
    if not uninstall_key_exists("MoganSTEM"):
        print('uninstallkey MoganSTEM not found')
        return "ERROR"
    else:
        return "OK"


